/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore;

/**
 * base class of exceptions thrown by {@link ObjectStoreService}. Subclasses describe error conditions more detail,
 * instances of this class are thrown if no subclass matches the condition.
 */
public class ObjectStoreException extends Exception {

  /** because it's serializable ... */
  private static final long serialVersionUID = 1L;

  /** create exception with description and causing exception. */
  public ObjectStoreException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** create exception with description only. */
  public ObjectStoreException(final String message) {
    super(message);
  }

  /** create exception from causing exception. */
  public ObjectStoreException(final Throwable cause) {
    super(cause);
  }

}
