/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - implementation
 **********************************************************************************************************************/
package org.eclipse.smila.processing.bpel;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.util.MessageHelper;

/**
 * service interface for the RequestTable service that keeps blackboard and pipelet exceptions during workflow
 * execution.
 */
public interface RequestTable {

  /** generate new request id and store blackboard. */
  String initRequest(final Blackboard blackboard);

  /**
   * get blackboard service for request.
   * 
   * @param id
   *          request ID
   * @return blackboard service.
   * @throws ProcessingException
   *           no blackboard associated with id
   */
  Blackboard getBlackboard(final String id) throws ProcessingException;

  /** get exception thrown by a pipelet in this pipeline. */
  Exception getPipeletException(final String requestId);

  /**
   * store a pipelet exception for better error reporting if the engine finally fails.
   * 
   * @param requestId
   *          id of request
   * @param ex
   *          exception thrown during pipelet execution.
   */
  void setPipeletException(final String requestId, final Exception ex);

  /** release blackboard and caught exception. */
  void cleanupRequest(final String requestId);

  /** get message helper. */
  MessageHelper getMessageHelper();

}
