package org.eclipse.smila.importing.util;

import java.io.IOException;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

/** write records to output bulks, split into multiple bulks by record count. */
public final class RecordOutputHandler {
  private final Outputs _outputs;

  private final String _slotName;

  private RecordOutput _recordOutput;

  private int _bulkCount;

  private int _recordCount;

  private final long _maxRecordsPerBulk;

  public RecordOutputHandler(final Outputs outputs, final long maxRecordsPerBulk, final String slotName) {
    _outputs = outputs;
    _slotName = slotName;
    _maxRecordsPerBulk = maxRecordsPerBulk;
    _recordCount = 0;
    _bulkCount = 0;
    _recordOutput = outputs.getAsRecordOutput(_slotName, _bulkCount);
  }

  public void writeRecord(final Record record) throws IOException, ObjectStoreException {
    _recordOutput.writeRecord(record);
    _recordCount++;
    if (_recordCount % _maxRecordsPerBulk == 0) {
      _recordOutput.commit();
      _bulkCount++;
      _recordOutput = _outputs.getAsRecordOutput(_slotName, _bulkCount);
    }
  }

  public int getFileCount() {
    return _recordCount;
  }
}
