/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

/** identification of the workflow run to which a record was submitted. */
public class WorkflowRunInfo {

  /** . */
  private final String _jobName;

  /** . */
  private final String _jobId;

  /** . */
  private final String _workflowId;

  /** create instance. */
  public WorkflowRunInfo(final String jobName, final String jobId, final String workflowId) {
    super();
    _jobName = jobName;
    _jobId = jobId;
    _workflowId = workflowId;
  }

  /** @return job name. */
  public String getJobName() {
    return _jobName;
  }

  /** @return job run Id. */
  public String getJobId() {
    return _jobId;
  }

  /** @return workflow run Id. */
  public String getWorkflowId() {
    return _workflowId;
  }

  @Override
  public String toString() {
    return _jobName + "/" + _jobId + "/" + _workflowId;
  }

  /** {@inheritDoc} */
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((_jobName == null) ? 0 : _jobName.hashCode());
    result = prime * result + (_jobId == null ? 0 : _jobId.hashCode());
    result = prime * result + (_workflowId == null ? 0 : _workflowId.hashCode());
    return result;
  }

  /** {@inheritDoc} */
  @Override
  public boolean equals(final Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final WorkflowRunInfo other = (WorkflowRunInfo) obj;
    if (_jobId == null) {
      if (other._jobId != null) {
        return false;
      }
    } else if (!_jobId.equals(other._jobId)) {
      return false;
    }
    if (_jobName == null) {
      if (other._jobName != null) {
        return false;
      }
    } else if (!_jobName.equals(other._jobName)) {
      return false;
    }
    if (_workflowId == null) {
      if (other._workflowId != null) {
        return false;
      }
    } else if (!_workflowId.equals(other._workflowId)) {
      return false;
    }
    return true;
  }

}
