package org.eclipse.smila.common.definitions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.smila.common.exceptions.InvalidDefinitionException;

/** check if a name contains only valid characters. */
public final class NameValidator {

  /** reg ex for a valid name. */
  public static final String VALID_NAME_EXPRESSION = "^[a-zA-Z0-9-_\\.]+$";

  /** pattern for a valid name. */
  private static final Pattern VALID_NAME_PATTERN = Pattern.compile(VALID_NAME_EXPRESSION);

  /** prohibit instantiation of this utility class. */
  private NameValidator() {
    throw new UnsupportedOperationException("Instantiation not allowed.");
  }

  /**
   * check if a name contains only valid characters.
   * 
   * @throws InvalidDefinitionException
   *           name contains invalid characters.
   */
  public static void checkName(final String name) throws InvalidDefinitionException {
    if (name == null) {
      throw new InvalidDefinitionException("A name must not be null.");
    }
    final Matcher m = VALID_NAME_PATTERN.matcher(name);
    if (!m.matches()) {
      throw new InvalidDefinitionException("A name must match pattern " + VALID_NAME_EXPRESSION + ".");
    }
  }
}
