/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.clusterconfig.ClusterConfigException;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class ZkConnection {
    public static final byte[] NO_DATA = new byte[0];
    private static final int MAX_NO_ZK_COMMAND_TRIES = 10;
    private static final long MIN_OPERATION_TIME_TO_LOG = 500L;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final ZooKeeperService _service;

    public ZkConnection(ZooKeeperService service) {
        this._service = service;
    }

    public long getSessionId() {
        try {
            return this._service.getClient().getSessionId();
        }
        catch (ClusterConfigException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createNode(String nodePath, byte[] data) throws KeeperException {
        this.createNode(nodePath, data, CreateMode.PERSISTENT);
    }

    public void createNode(final String nodePath, final byte[] data, final CreateMode mode) throws KeeperException {
        this.retryZkCommand(new ZkCallable(){
            private boolean _firstTry = true;

            @Override
            public String getZkOperation() {
                return "createNode '" + nodePath + "', mode '" + mode + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                try {
                    ZkConnection.this.getClient().create(nodePath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
                }
                catch (KeeperException.NodeExistsException e) {
                    if (this._firstTry) {
                        throw e;
                    }
                }
                catch (KeeperException.ConnectionLossException e) {
                    this._firstTry = false;
                    throw e;
                }
                catch (KeeperException.SessionExpiredException e) {
                    this._firstTry = false;
                    throw e;
                }
                return null;
            }
        });
    }

    public void createPath(String nodePath, byte[] data) throws KeeperException {
        int i = 0;
        while (i < 2) {
            try {
                this.createNode(nodePath, data);
                return;
            }
            catch (KeeperException.NoNodeException noNodeException) {
                int indexOfSlash = nodePath.lastIndexOf(47);
                if (indexOfSlash > 0) {
                    String parentPath = nodePath.substring(0, indexOfSlash);
                    try {
                        this.createPath(parentPath, NO_DATA);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {}
                }
                ++i;
            }
        }
    }

    public void ensurePathExists(String path) throws KeeperException {
        if (this.exists(path) == null) {
            try {
                this.createPath(path, NO_DATA);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        }
    }

    public void deleteNode(final String nodePath) throws KeeperException {
        if (this.exists(nodePath) == null) {
            throw new KeeperException.NoNodeException(nodePath);
        }
        this.retryZkCommand(new ZkCallable(){
            private boolean _firstTry = true;

            @Override
            public String getZkOperation() {
                return "deleteNode '" + nodePath + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                try {
                    ZkConnection.this.getClient().delete(nodePath, -1);
                }
                catch (KeeperException.NoNodeException e) {
                    if (this._firstTry) {
                        throw e;
                    }
                }
                catch (KeeperException.ConnectionLossException e) {
                    this._firstTry = false;
                    throw e;
                }
                catch (KeeperException.SessionExpiredException e) {
                    this._firstTry = false;
                    throw e;
                }
                return null;
            }
        });
    }

    public void deleteTree(String nodePath) throws KeeperException {
        try {
            List<String> children = this.getChildrenSorted(nodePath);
            String root = String.valueOf(nodePath) + '/';
            for (String childNode : children) {
                String childPath = String.valueOf(root) + childNode;
                this.deleteTree(childPath);
            }
            this.deleteNode(nodePath);
        }
        catch (KeeperException.NoNodeException noNodeException) {}
    }

    public Stat exists(final String nodePath) throws KeeperException {
        return (Stat)this.retryZkCommand(new ZkCallable(){

            @Override
            public String getZkOperation() {
                return "exists '" + nodePath + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                return ZkConnection.this.getClient().exists(nodePath, false);
            }
        });
    }

    public Stat exists(final String nodePath, final Watcher watcher) throws KeeperException {
        return (Stat)this.retryZkCommand(new ZkCallable(){

            @Override
            public String getZkOperation() {
                return "exists '" + nodePath + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                return ZkConnection.this.getClient().exists(nodePath, watcher);
            }
        });
    }

    public Stat exists(final String nodePath, final long timeout) throws KeeperException {
        return (Stat)this.retryZkCommand(new ZkCallable(){

            @Override
            public String getZkOperation() {
                return "async exists'" + nodePath + "'";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws KeeperException, InterruptedException {
                if (ZkConnection.this._log.isDebugEnabled()) {
                    ZkConnection.this._log.debug((Object)("Checking for existence of " + nodePath + " asynchronously."));
                }
                StatCallback cb = new StatCallback();
                ZkConnection.this.getClient().exists(nodePath, false, (AsyncCallback.StatCallback)cb, null);
                StatCallback statCallback = cb;
                synchronized (statCallback) {
                    cb.wait(timeout);
                }
                return cb._stat;
            }
        });
    }

    public Stat setData(final String nodePath, final byte[] nodeData, final int version) throws KeeperException {
        return (Stat)this.retryZkCommand(new ZkCallable(){

            @Override
            public String getZkOperation() {
                return "setData '" + nodePath + "', version '" + version + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                return ZkConnection.this.getClient().setData(nodePath, nodeData, version);
            }
        });
    }

    public Stat setData(String nodePath, byte[] nodeData) throws KeeperException {
        return this.setData(nodePath, nodeData, -1);
    }

    public byte[] getData(String nodePath) throws KeeperException {
        return this.getData(nodePath, new Stat());
    }

    public byte[] getData(final String nodePath, final Stat stat) throws KeeperException {
        return (byte[])this.retryZkCommand(new ZkCallable(){

            @Override
            public String getZkOperation() {
                return "getData '" + nodePath + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                return ZkConnection.this.getClient().getData(nodePath, false, stat);
            }
        });
    }

    public List<String> getChildrenSorted(final String nodePath) throws KeeperException {
        List children = (List)this.retryZkCommand(new ZkCallable(){

            @Override
            public String getZkOperation() {
                return "getChildrenSorted '" + nodePath + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                return ZkConnection.this.getClient().getChildren(nodePath, false);
            }
        });
        Collections.sort(children);
        return children;
    }

    public List<String> getLeafNodes(final String startNodePath) throws KeeperException {
        List children = (List)this.retryZkCommand(new ZkCallable(){

            @Override
            public String getZkOperation() {
                return "getLeafNodes '" + startNodePath + "'";
            }

            @Override
            public Object call() throws KeeperException, InterruptedException {
                ArrayList<String> children = new ArrayList<String>();
                this.collectLeafNodes(startNodePath, children);
                return children;
            }

            private void collectLeafNodes(String node, List<String> allChildren) throws KeeperException, InterruptedException {
                List children = ZkConnection.this.getClient().getChildren(node, false);
                for (String child : children) {
                    String childNode = String.valueOf(node) + "/" + child;
                    Stat stat = ZkConnection.this.getClient().exists(childNode, false);
                    if (stat.getNumChildren() == 0) {
                        allChildren.add(childNode);
                        continue;
                    }
                    this.collectLeafNodes(childNode, allChildren);
                }
            }
        });
        return children;
    }

    public void disconnectZkSession() throws IOException, ClusterConfigException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Disconnecting ZK session.");
        }
        this._service.closeClient();
    }

    private ZooKeeper getClient() {
        try {
            return this._service.getClient();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object retryZkCommand(ZkCallable callable) throws KeeperException {
        long start = System.currentTimeMillis();
        int tries = 0;
        while (tries < 10) {
            ++tries;
            try {
                long t;
                Object result = callable.call();
                if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 500L) {
                    this._log.info((Object)("ZkConnection operation time: " + t + " ms, tries: " + tries + ", operation: " + callable.getZkOperation()));
                }
                return result;
            }
            catch (InterruptedException interruptedException) {
                this._log.info((Object)("Interrupted exception during " + callable.getZkOperation() + ", retrying."));
            }
            catch (KeeperException.ConnectionLossException connectionLossException) {
                this._log.warn((Object)"ConnectionLoss exception");
                this._service.waitForClientConnected();
            }
            catch (KeeperException.SessionExpiredException e) {
                this._log.warn((Object)"SessionExpired exception", (Throwable)e);
                this._service.waitForClientConnected();
            }
        }
        throw new RuntimeException("Reached maximum number of tries (10) for zookeeper client command");
    }

    private class StatCallback
    implements AsyncCallback.StatCallback {
        private Stat _stat;

        private StatCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processResult(int rc, String path, Object ctx, Stat stat) {
            this._stat = stat;
            StatCallback statCallback = this;
            synchronized (statCallback) {
                this.notifyAll();
            }
        }
    }

    private static interface ZkCallable {
        public Object call() throws KeeperException, InterruptedException;

        public String getZkOperation();
    }
}

