/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.zookeeper.ZkConnection;

public class ZkLock {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final ZkConnection _zk;
    private final String _lockPath;
    private long _currentZkClientSessionId;

    public ZkLock(ZkConnection zk, String lockRootNodePath) {
        if (lockRootNodePath == null) {
            throw new NullPointerException("parameter lockRootNodePath is <null>");
        }
        this._zk = zk;
        this._lockPath = String.valueOf(lockRootNodePath) + "/" + "lock";
        Stat stat = null;
        try {
            stat = this._zk.exists(lockRootNodePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (stat == null) {
            throw new IllegalArgumentException("root zookeeper node '" + lockRootNodePath + "' doesn't exist!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"tryLock()");
        }
        try {
            if (this._zk.exists(this._lockPath) != null) {
                return false;
            }
            try {
                this._zk.createNode(this._lockPath, ZkConnection.NO_DATA, CreateMode.EPHEMERAL);
                this._currentZkClientSessionId = this._zk.getSessionId();
                return true;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unlock() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"unlock()");
        }
        try {
            this._zk.deleteNode(this._lockPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            if (this._zk.getSessionId() == this._currentZkClientSessionId) {
                this._log.warn((Object)"Could not remove lock because lock wasn't set before.");
            } else {
                this._log.warn((Object)"Could not remove lock because session expired in between");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLockStillValid() {
        return this._zk.getSessionId() == this._currentZkClientSessionId;
    }
}

