/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementCategory;
import org.eclipse.smila.management.internal.ManagementAgentLocationImpl;
import org.eclipse.smila.management.internal.ManagementTreeNodeImpl;

public class ManagementCategoryImpl
extends ManagementTreeNodeImpl
implements ManagementCategory {
    public ManagementCategoryImpl(String name) {
        this(name, null);
    }

    public ManagementCategoryImpl(String name, ManagementCategory parentCategory) {
        if (name != null) {
            Pattern pattern = Pattern.compile("[^\\w\\/]", 2);
            Matcher matcher = pattern.matcher(name);
            if (matcher.matches()) {
                throw new IllegalArgumentException("Name should contains only words symbols,  digits, underscore or /");
            }
            name = name.replaceAll("^/+", "");
            name = name.replaceAll("/+$", "");
        }
        String path = parentCategory != null ? parentCategory.getPath() : "";
        if (name != null) {
            if (path != null && !"".equals(path)) {
                path = String.valueOf(path) + "/";
            }
            path = String.valueOf(path) + name;
        }
        this._path = path;
    }

    @Override
    public ManagementCategory getCategory(String name) {
        return new ManagementCategoryImpl(name, this);
    }

    @Override
    public ManagementAgentLocation getLocation(String name) {
        return new ManagementAgentLocationImpl(this, name);
    }
}

