/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetIndoubtTransaction;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetXACallInfo;

public class NetXAConnectionReply
extends NetResultSetReply {
    NetXAConnectionReply(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    public void readLocalXAStart(ConnectionCallbackInterface connection) throws DisconnectException {
    }

    public void readLocalXACommit(ConnectionCallbackInterface connection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connection);
        this.endOfSameIdChainData();
        NetXACallInfo callInfo = this.netAgent_.netConnection_.xares_.callInfoArray_[this.netAgent_.netConnection_.currXACallInfoOffset_];
        callInfo.xaInProgress_ = false;
        callInfo.xaWasSuspended = false;
        connection.completeLocalCommit();
    }

    public void readLocalXARollback(ConnectionCallbackInterface connection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connection);
        this.endOfSameIdChainData();
        connection.completeLocalRollback();
    }

    protected void readXaStartUnitOfWork(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
    }

    protected int readXaEndUnitOfWork(NetConnection conn) throws DisconnectException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        int xaFlags = callInfo.xaFlags_;
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        if (xaFlags == 0x20000000) {
            return 100;
        }
        return 0;
    }

    protected int readXaPrepare(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        int synctype = this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        if (synctype == 3) {
            callInfo.setReadOnlyTransactionFlag(true);
        } else {
            callInfo.setReadOnlyTransactionFlag(false);
        }
        return synctype;
    }

    protected void readXaCommit(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        callInfo.xaInProgress_ = false;
        conn.completeLocalCommit();
    }

    protected int readXaRollback(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        callInfo.xaInProgress_ = false;
        callInfo.xaWasSuspended = false;
        conn.completeLocalRollback();
        return 0;
    }

    protected void readXaRecover(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
    }

    protected void readXaForget(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
    }

    int parseSYNCCRD(ConnectionCallbackInterface connection) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        int xaretval = 0;
        byte synctype = 0;
        Hashtable indoubtTransactions = null;
        NetConnection conn = this.netAgent_.netConnection_;
        this.parseLengthAndMatchCodePoint(4680);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 6404) {
                foundInPass = true;
                conn.xares_.callInfoArray_[conn.currXACallInfoOffset_].xaRetVal_ = xaretval = this.parseXARETVAL();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4487) {
                foundInPass = true;
                synctype = this.parseSYNCTYPE();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 6405) {
                foundInPass = true;
                indoubtTransactions = this.parseIndoubtList();
                conn.setIndoubtTransactions(indoubtTransactions);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        return xaretval;
    }

    protected int parseXARETVAL() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6404);
        return this.readInt();
    }

    protected byte parseSYNCTYPE() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4487);
        return this.readByte();
    }

    protected int parseSYNCCTLreply(ConnectionCallbackInterface connection) throws DisconnectException {
        int retval = 0;
        int peekCP = this.peekCodePoint();
        if (peekCP != 4680) {
            this.parseSYNCCTLError(peekCP);
            return -1;
        }
        retval = this.parseSYNCCRD(connection);
        peekCP = this.peekCodePoint();
        while (peekCP == 9236) {
            String s = this.parseSQLSTT();
            this.netAgent_.netConnection_.xares_.addSpecialRegisters(s);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 49152) {
            this.parsePBSD();
        }
        return retval;
    }

    private String parseSQLSTT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9236);
        return this.parseSQLSTTGRPNOCMorNOCS();
    }

    private String parseSQLSTTGRPNOCMorNOCS() throws DisconnectException {
        int mixedNullInd = this.readUnsignedByte();
        int singleNullInd = 0;
        String sqlsttString = null;
        int stringLength = 0;
        if (mixedNullInd == 255) {
            singleNullInd = this.readUnsignedByte();
            if (singleNullInd == 255) {
                this.doDtamchrmSemantics();
            }
            stringLength = this.readInt();
            sqlsttString = this.readString(stringLength, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        } else {
            stringLength = this.readInt();
            sqlsttString = this.readString(stringLength, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            singleNullInd = this.readUnsignedByte();
        }
        return sqlsttString;
    }

    protected int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    protected Xid parseXID() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6145);
        int formatId = this.readInt();
        int gtridLen = this.readInt();
        int bqualLen = this.readInt();
        byte[] gtrid = this.readBytes(gtridLen);
        byte[] bqual = this.readBytes(bqualLen);
        return new ClientXid(formatId, gtrid, bqual);
    }

    protected Hashtable parseIndoubtList() throws DisconnectException {
        boolean found = false;
        int port = 0;
        int numXid = 0;
        String sIpAddr = null;
        int peekCP = this.peekCodePoint();
        this.parseLengthAndMatchCodePoint(6405);
        peekCP = this.peekCodePoint();
        if (peekCP == 6406) {
            found = true;
            numXid = this.parseXIDCNT();
            peekCP = this.peekCodePoint();
        }
        Hashtable<Xid, NetIndoubtTransaction> indoubtTransactions = new Hashtable<Xid, NetIndoubtTransaction>();
        while (peekCP == 6145) {
            Xid xid = this.parseXID();
            indoubtTransactions.put(xid, new NetIndoubtTransaction(xid, null, null, null, sIpAddr, port));
            peekCP = this.peekCodePoint();
        }
        return indoubtTransactions;
    }
}

