/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.jdbc.InternalDriver;

abstract class ConnectionChild {
    EmbedConnection localConn;
    final InternalDriver factory;
    private Calendar cal;

    ConnectionChild(EmbedConnection conn) {
        this.localConn = conn;
        this.factory = conn.getLocalDriver();
    }

    final EmbedConnection getEmbedConnection() {
        return this.localConn;
    }

    final Object getConnectionSynchronization() {
        return this.localConn.getConnectionSynchronization();
    }

    final SQLException handleException(Throwable t) throws SQLException {
        return this.localConn.handleException(t);
    }

    final void needCommit() {
        this.localConn.needCommit();
    }

    final void commitIfNeeded() throws SQLException {
        this.localConn.commitIfNeeded();
    }

    final void commitIfAutoCommit() throws SQLException {
        this.localConn.commitIfAutoCommit();
    }

    final void setupContextStack() throws SQLException {
        this.localConn.setupContextStack();
    }

    final void restoreContextStack() throws SQLException {
        this.localConn.restoreContextStack();
    }

    Calendar getCal() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    SQLException newSQLException(String messageId) {
        return this.localConn.newSQLException(messageId);
    }

    SQLException newSQLException(String messageId, Object arg1) {
        return this.localConn.newSQLException(messageId, arg1);
    }

    SQLException newSQLException(String messageId, Object arg1, Object arg2) {
        return this.localConn.newSQLException(messageId, arg1, arg2);
    }
}

