/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;

public class DeleteNode
extends DMLModStatementNode {
    private static final String COLUMNNAME = "###RowLocationToDelete";
    protected boolean deferred;
    protected ExecRow emptyHeapRow;
    protected FromTable targetTable;
    protected FKInfo fkInfo;
    protected FormatableBitSet readColsBitSet;
    private ConstantAction[] dependentConstantActions;
    private boolean cascadeDelete;
    private StatementNode[] dependentNodes;

    public void init(Object targetTableName, Object queryExpression) {
        super.init(queryExpression);
        this.targetTableName = (TableName)targetTableName;
    }

    public String statementToString() {
        return "DELETE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(0);
        try {
            String currentTargetTableName;
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            ResultColumn rowLocationColumn = null;
            TableName cursorTargetTableName = null;
            CurrentOfNode currentOfNode = null;
            DataDictionary dataDictionary = this.getDataDictionary();
            super.bindTables(dataDictionary);
            SanityManager.ASSERT(this.resultSet != null && this.resultSet instanceof SelectNode, "Delete must have a select result set");
            SelectNode sel = (SelectNode)this.resultSet;
            this.targetTable = (FromTable)sel.fromList.elementAt(0);
            if (this.targetTable instanceof CurrentOfNode) {
                currentOfNode = (CurrentOfNode)this.targetTable;
                cursorTargetTableName = currentOfNode.getBaseCursorTargetTableName();
                SanityManager.ASSERT(cursorTargetTableName != null);
            }
            if (this.targetTable instanceof FromVTI) {
                this.targetVTI = (FromVTI)this.targetTable;
                this.targetVTI.setTarget();
            } else if (this.targetTableName == null) {
                SanityManager.ASSERT(cursorTargetTableName != null);
                this.targetTableName = cursorTargetTableName;
            } else if (cursorTargetTableName != null && !this.targetTableName.equals(cursorTargetTableName)) {
                throw StandardException.newException("42X28", (Object)this.targetTableName, (Object)currentOfNode.getCursorName());
            }
            this.verifyTargetTable();
            SanityManager.ASSERT(this.resultSet.resultColumns == null, "resultColumns is expected to be null until bind time");
            if (this.targetTable instanceof FromVTI) {
                this.getResultColumnList();
                this.resultColumnList = this.targetTable.getResultColumnsForList(null, this.resultColumnList, null);
                this.resultSet.setResultColumns(this.resultColumnList);
            } else {
                int i;
                this.resultColumnList = new ResultColumnList();
                FromBaseTable fbt = this.getResultColumnList(this.resultColumnList);
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor);
                this.resultColumnList = fbt.addColsToList(this.resultColumnList, this.readColsBitSet);
                int size = this.targetTableDescriptor.getMaxColumnID();
                for (i = 1; i <= size && this.readColsBitSet.get(i); ++i) {
                }
                if (i > size) {
                    this.readColsBitSet = null;
                }
                this.emptyHeapRow = this.targetTableDescriptor.getEmptyExecRow();
                CurrentRowLocationNode rowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
                rowLocationColumn = (ResultColumn)this.getNodeFactory().getNode(80, COLUMNNAME, rowLocationNode, this.getContextManager());
                rowLocationColumn.markGenerated();
                this.resultColumnList.addResultColumn(rowLocationColumn);
                this.correlateAddedColumns(this.resultColumnList, this.targetTable);
                this.resultSet.setResultColumns(this.resultColumnList);
            }
            super.bindExpressions();
            this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
            if (!(this.targetTable instanceof FromVTI)) {
                rowLocationColumn.bindResultColumnToExpression();
                this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, this.resultColumnList, null, this.readColsBitSet, false, true);
                if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                    this.deferred = true;
                }
            } else {
                this.deferred = VTIDeferModPolicy.deferIt(3, this.targetVTI, null, sel.getWhereClause());
            }
            sel = null;
            SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
            if (this.fkTableNames != null) {
                currentTargetTableName = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                if (!this.isDependentTable) {
                    this.graphHashTable = new Hashtable();
                }
                if (!this.graphHashTable.containsKey(currentTargetTableName)) {
                    this.cascadeDelete = true;
                    int noDependents = this.fkTableNames.length;
                    this.dependentNodes = new StatementNode[noDependents];
                    this.graphHashTable.put(currentTargetTableName, new Integer(noDependents));
                    for (int i = 0; i < noDependents; ++i) {
                        this.dependentNodes[i] = this.getDependentTableNode(this.fkTableNames[i], this.fkRefActions[i], this.fkColDescriptors[i]);
                        this.dependentNodes[i].bindStatement();
                    }
                }
            } else if (this.isDependentTable) {
                currentTargetTableName = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                this.graphHashTable.put(currentTargetTableName, new Integer(0));
            }
            if (this.isPrivilegeCollectionRequired()) {
                this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
                this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
                this.getCompilerContext().popCurrentPrivType();
            }
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
    }

    int getPrivType() {
        return 4;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            int lockMode = this.resultSet.updateTargetLockMode();
            long heapConglomId = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            StaticCompiledOpenConglomInfo[] indexSCOCIs = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
            for (int index = 0; index < indexSCOCIs.length; ++index) {
                indexSCOCIs[index] = tc.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[index]);
            }
            if (this.targetTableDescriptor.getLockGranularity() == 'T') {
                lockMode = 7;
            }
            ResultDescription resultDescription = null;
            if (this.isDependentTable) {
                resultDescription = this.makeResultDescription();
            }
            return this.getGenericConstantActionFactory().getDeleteConstantAction(heapConglomId, this.targetTableDescriptor.getTableType(), tc.getStaticCompiledConglomInfo(heapConglomId), this.indicesToMaintain, this.indexConglomerateNumbers, indexSCOCIs, this.emptyHeapRow, this.deferred, false, this.targetTableDescriptor.getUUID(), lockMode, null, null, null, 0L, null, null, resultDescription, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), DeleteNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), null, this.resultSet.isOneRowResultSet(), this.dependentConstantActions);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(3, this.deferred);
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int numResultSets;
        String parentResultSetId;
        int argCount;
        String resultSetGetter;
        this.generateCodeForTemporaryTable(acb, acb.getExecuteMethod());
        if (!this.isDependentTable) {
            this.generateParameterValueSet(acb);
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.newRowLocationScanResultSetName();
        this.resultSet.generate(acb, mb);
        if (this.targetTableDescriptor != null) {
            acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", acb.getRowLocationScanResultSetName());
            if (this.cascadeDelete || this.isDependentTable) {
                resultSetGetter = "getDeleteCascadeResultSet";
                argCount = 4;
            } else {
                resultSetGetter = "getDeleteResultSet";
                argCount = 1;
            }
        } else {
            argCount = 1;
            resultSetGetter = "getDeleteVTIResultSet";
        }
        if (this.isDependentTable) {
            mb.push(acb.addItem(this.makeConstantAction()));
        } else if (this.cascadeDelete) {
            mb.push(-1);
        }
        String resultSetArrayType = "org.apache.derby.iapi.sql.ResultSet[]";
        if (this.cascadeDelete) {
            parentResultSetId = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            LocalField arrayField = acb.newFieldDeclaration(2, resultSetArrayType);
            mb.pushNewArray("org.apache.derby.iapi.sql.ResultSet", this.dependentNodes.length);
            mb.setField(arrayField);
            for (int index = 0; index < this.dependentNodes.length; ++index) {
                this.dependentNodes[index].setRefActionInfo(this.fkIndexConglomNumbers[index], this.fkColArrays[index], parentResultSetId, true);
                mb.getField(arrayField);
                if (mb.statementNumHitLimit(10)) {
                    MethodBuilder dmb = acb.newGeneratedFun("org.apache.derby.iapi.sql.ResultSet", 2);
                    this.dependentNodes[index].generate(acb, dmb);
                    dmb.methodReturn();
                    dmb.complete();
                    mb.pushThis();
                    mb.callMethod((short)182, null, dmb.getName(), "org.apache.derby.iapi.sql.ResultSet", 0);
                } else {
                    this.dependentNodes[index].generate(acb, mb);
                }
                mb.setArrayElement(index);
            }
            mb.getField(arrayField);
        } else if (this.isDependentTable) {
            mb.pushNull(resultSetArrayType);
        }
        if (this.cascadeDelete || this.isDependentTable) {
            parentResultSetId = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            mb.push(parentResultSetId);
        }
        mb.callMethod((short)185, null, resultSetGetter, "org.apache.derby.iapi.sql.ResultSet", argCount);
        if (!this.isDependentTable && this.cascadeDelete && (numResultSets = acb.getRowCount()) > 0) {
            MethodBuilder constructor = acb.getConstructor();
            constructor.pushThis();
            constructor.pushNewArray("org.apache.derby.iapi.sql.execute.CursorResultSet", numResultSets);
            constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "raParentResultSets", "org.apache.derby.iapi.sql.execute.CursorResultSet[]");
            constructor.endStatement();
        }
    }

    protected final int getStatementType() {
        return 4;
    }

    public FormatableBitSet getReadMap(DataDictionary dd, TableDescriptor baseTable) throws StandardException {
        boolean[] needsDeferredProcessing = new boolean[]{this.requiresDeferredProcessing()};
        Vector conglomVector = new Vector();
        this.relevantTriggers = new GenericDescriptorList();
        FormatableBitSet columnMap = DeleteNode.getDeleteReadMap(baseTable, conglomVector, this.relevantTriggers, needsDeferredProcessing);
        this.markAffectedIndexes(conglomVector);
        this.adjustDeferredFlag(needsDeferredProcessing[0]);
        return columnMap;
    }

    private StatementNode getDependentTableNode(String tableName, int refAction, ColumnDescriptorList cdl) throws StandardException {
        StatementNode node = null;
        int index = tableName.indexOf(46);
        String schemaName = tableName.substring(0, index);
        String tName = tableName.substring(index + 1);
        if (refAction == 0) {
            node = this.getEmptyDeleteNode(schemaName, tName);
            ((DeleteNode)node).isDependentTable = true;
            ((DeleteNode)node).graphHashTable = this.graphHashTable;
        }
        if (refAction == 3) {
            node = this.getEmptyUpdateNode(schemaName, tName, cdl);
            ((UpdateNode)node).isDependentTable = true;
            ((UpdateNode)node).graphHashTable = this.graphHashTable;
        }
        return node;
    }

    private StatementNode getEmptyDeleteNode(String schemaName, String targetTableName) throws StandardException {
        Object whereClause = null;
        TableName tableName = new TableName();
        tableName.init(schemaName, targetTableName);
        NodeFactory nodeFactory = this.getNodeFactory();
        FromList fromList = (FromList)nodeFactory.getNode(37, this.getContextManager());
        FromTable fromTable = (FromTable)nodeFactory.getNode(135, tableName, null, ReuseFactory.getInteger(2), null, this.getContextManager());
        FormatableProperties targetProperties = new FormatableProperties();
        targetProperties.put("index", "null");
        ((FromBaseTable)fromTable).setTableProperties(targetProperties);
        fromList.addFromTable(fromTable);
        SelectNode resultSet = (SelectNode)nodeFactory.getNode(129, null, null, fromList, whereClause, null, null, this.getContextManager());
        return (StatementNode)nodeFactory.getNode(101, tableName, resultSet, this.getContextManager());
    }

    private StatementNode getEmptyUpdateNode(String schemaName, String targetTableName, ColumnDescriptorList cdl) throws StandardException {
        Object whereClause = null;
        TableName tableName = new TableName();
        tableName.init(schemaName, targetTableName);
        NodeFactory nodeFactory = this.getNodeFactory();
        FromList fromList = (FromList)nodeFactory.getNode(37, this.getContextManager());
        FromTable fromTable = (FromTable)nodeFactory.getNode(135, tableName, null, ReuseFactory.getInteger(2), null, this.getContextManager());
        FormatableProperties targetProperties = new FormatableProperties();
        targetProperties.put("index", "null");
        ((FromBaseTable)fromTable).setTableProperties(targetProperties);
        fromList.addFromTable(fromTable);
        SelectNode resultSet = (SelectNode)nodeFactory.getNode(129, this.getSetClause(tableName, cdl), null, fromList, whereClause, null, null, this.getContextManager());
        return (StatementNode)nodeFactory.getNode(102, tableName, resultSet, this.getContextManager());
    }

    private ResultColumnList getSetClause(TableName tabName, ColumnDescriptorList cdl) throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        ResultColumnList columnList = (ResultColumnList)nodeFactory.getNode(9, this.getContextManager());
        ValueNode valueNode = (ValueNode)nodeFactory.getNode(13, this.getContextManager());
        for (int index = 0; index < cdl.size(); ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (!cd.getType().isNullable()) continue;
            ResultColumn resultColumn = (ResultColumn)nodeFactory.getNode(80, cd, valueNode, this.getContextManager());
            columnList.addResultColumn(resultColumn);
        }
        return columnList;
    }

    public void optimizeStatement() throws StandardException {
        if (this.cascadeDelete) {
            for (int index = 0; index < this.dependentNodes.length; ++index) {
                this.dependentNodes[index].optimizeStatement();
            }
        }
        super.optimizeStatement();
    }

    private static FormatableBitSet getDeleteReadMap(TableDescriptor baseTable, Vector conglomVector, GenericDescriptorList relevantTriggers, boolean[] needsDeferredProcessing) throws StandardException {
        int columnCount = baseTable.getMaxColumnID();
        FormatableBitSet columnMap = new FormatableBitSet(columnCount + 1);
        DMLModStatementNode.getXAffectedIndexes(baseTable, null, columnMap, conglomVector);
        baseTable.getAllRelevantTriggers(4, null, relevantTriggers);
        if (relevantTriggers.size() > 0) {
            needsDeferredProcessing[0] = true;
        }
        if (relevantTriggers.size() > 0) {
            for (int i = 1; i <= columnCount; ++i) {
                columnMap.set(i);
            }
        }
        return columnMap;
    }

    private void correlateAddedColumns(ResultColumnList rcl, FromTable fromTable) throws StandardException {
        String correlationName = fromTable.getCorrelationName();
        if (correlationName == null) {
            return;
        }
        TableName correlationNameNode = this.makeTableName(null, correlationName);
        int count = rcl.size();
        for (int i = 0; i < count; ++i) {
            ResultColumn column = (ResultColumn)rcl.elementAt(i);
            ValueNode expression = column.getExpression();
            if (expression == null || !(expression instanceof ColumnReference)) continue;
            ColumnReference reference = (ColumnReference)expression;
            reference.setTableNameNode(correlationNameNode);
        }
    }
}

