/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;

class LockTableConstantAction
implements ConstantAction {
    private final String fullTableName;
    private final long conglomerateNumber;
    private final boolean exclusiveMode;

    LockTableConstantAction(String fullTableName, long conglomerateNumber, boolean exclusiveMode) {
        this.fullTableName = fullTableName;
        this.conglomerateNumber = conglomerateNumber;
        this.exclusiveMode = exclusiveMode;
    }

    public String toString() {
        return "LOCK TABLE " + this.fullTableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        TransactionController tc = activation.getTransactionController();
        try {
            ConglomerateController cc = tc.openConglomerate(this.conglomerateNumber, false, this.exclusiveMode ? 68 : 64, 7, 5);
            cc.close();
        }
        catch (StandardException se) {
            String msgId = se.getMessageId();
            if (msgId.equals("40001") || msgId.equals("40XL1") || msgId.equals("40XL2")) {
                String mode = this.exclusiveMode ? "EXCLUSIVE" : "SHARE";
                se = StandardException.newException("X0X02.S", se, (Object)this.fullTableName, (Object)mode);
            }
            throw se;
        }
    }
}

