/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.RecordMerger;
import org.eclipse.smila.importing.crawler.jdbc.internal.ResultSetToAnyConverter;
import org.eclipse.smila.importing.util.MessageCollector;

public class SqlExecutor
implements AutoCloseable {
    private final String _sql;
    private final Connection _con;
    private final PreparedStatement _stmt;
    private final long _maxAttachmentSize;
    private final MessageCollector _messages;

    public SqlExecutor(Connection con, String sql, long maxAttachmentSize, MessageCollector messages) throws SQLException {
        this._sql = sql;
        this._con = con;
        this._stmt = con.prepareStatement(sql);
        this._maxAttachmentSize = maxAttachmentSize;
        this._messages = messages;
    }

    public String getSql() {
        return this._sql;
    }

    public Record execute(List<Value> parameters) throws SQLException, IOException {
        ResultSet rs = null;
        int j = 0;
        while (j < parameters.size()) {
            Any param = (Any)parameters.get(j);
            if (param == null) {
                throw new IllegalArgumentException("NULL parameters are not supported.");
            }
            this._stmt.setObject(j + 1, param.asValue().getObject());
            ++j;
        }
        rs = this._stmt.executeQuery();
        Collection<Record> result = ResultSetToAnyConverter.convertResultSetToAny(rs, this._maxAttachmentSize, this._messages);
        return this.mergeRecords(result);
    }

    @Override
    public void close() {
        if (this._stmt != null) {
            try {
                this._stmt.close();
            }
            catch (Exception exception) {}
        }
        if (this._con != null) {
            try {
                this._con.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private Record mergeRecords(Collection<Record> recordsToMerge) {
        if (recordsToMerge.size() == 0) {
            return null;
        }
        if (recordsToMerge.size() == 1) {
            return recordsToMerge.iterator().next();
        }
        Iterator<Record> it = recordsToMerge.iterator();
        Record result = it.next();
        while (it.hasNext()) {
            Record r = it.next();
            RecordMerger.mergeRecords((Record)result, (Record)r, (boolean)true);
        }
        return result;
    }
}

