/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.InstrumentationFactory;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRedefiner {
    private static final Localizer _loc = Localizer.forPackage(ClassRedefiner.class);
    private static Boolean _canRedefine = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void redefineClasses(OpenJPAConfiguration conf, final Map<Class, byte[]> classes) {
        if (classes == null) return;
        if (classes.size() == 0) return;
        if (!ClassRedefiner.canRedefineClasses()) {
            return;
        }
        Log log = conf.getLog("openjpa.Enhance");
        Instrumentation inst = null;
        ClassFileTransformer t = null;
        try {
            try {
                inst = InstrumentationFactory.getInstrumentation();
                Class[] array = classes.keySet().toArray(new Class[classes.size()]);
                if (JavaVersions.VERSION >= 6) {
                    log.trace(_loc.get("retransform-types", classes.keySet()));
                    t = new ClassFileTransformer(){

                        @Override
                        public byte[] transform(ClassLoader loader, String clsName, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] classfileBuffer) {
                            return (byte[])classes.get(classBeingRedefined);
                        }
                    };
                    Method meth = inst.getClass().getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
                    meth.invoke((Object)inst, t, true);
                    meth = inst.getClass().getMethod("retransformClasses", array.getClass());
                    meth.invoke((Object)inst, new Object[]{array});
                } else {
                    log.trace(_loc.get("redefine-types", classes.keySet()));
                    ClassDefinition[] defs = new ClassDefinition[array.length];
                    for (int i = 0; i < defs.length; ++i) {
                        defs[i] = new ClassDefinition(array[i], classes.get(array[i]));
                    }
                    inst.redefineClasses(defs);
                }
            }
            catch (NoSuchMethodException e) {
                throw new InternalException(e);
            }
            catch (IllegalAccessException e) {
                throw new InternalException(e);
            }
            catch (InvocationTargetException e) {
                throw new UserException(e.getCause());
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
            catch (ClassNotFoundException e) {
                throw new InternalException(e);
            }
            catch (UnmodifiableClassException e) {
                throw new InternalException(e);
            }
            Object var9_15 = null;
            if (inst == null) return;
            if (t == null) return;
            inst.removeTransformer(t);
            return;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (inst == null) throw throwable;
            if (t == null) throw throwable;
            inst.removeTransformer(t);
            throw throwable;
        }
    }

    public static boolean canRedefineClasses() {
        if (_canRedefine == null) {
            try {
                Instrumentation inst = InstrumentationFactory.getInstrumentation();
                _canRedefine = inst == null ? Boolean.FALSE : (JavaVersions.VERSION == 5 ? Boolean.TRUE : (Boolean)Instrumentation.class.getMethod("isRetransformClassesSupported", new Class[0]).invoke((Object)inst, new Object[0]));
            }
            catch (Exception e) {
                _canRedefine = Boolean.FALSE;
            }
        }
        return _canRedefine;
    }
}

