/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.json;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonHttpUtils;
import org.eclipse.smila.http.server.util.ARequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;

public abstract class JsonRequestHandler
extends ARequestHandler {
    protected static final String HEADER_REQUEST_HOST = "Host";
    protected static final DataFactory FACTORY = DataFactory.DEFAULT;
    protected static final JsonHttpUtils HTTP_UTILS = new JsonHttpUtils();
    private final Log _log = LogFactory.getLog(this.getClass());

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        return null;
    }

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        return this.process(method, requestUri, inputRecord);
    }

    @Override
    public void handle(HttpExchange exchange) {
        boolean closeConnection = false;
        Object resultObject = null;
        String method = exchange.getRequestMethod();
        String requestUri = exchange.getRequestURI();
        Record inputRecord = null;
        try {
            if (!this.isValidMethod(method, requestUri)) {
                throw new UnsupportedMethodException("Unsupported http method '" + method + "'");
            }
            inputRecord = HTTP_UTILS.convertRequest(exchange);
            resultObject = this.process(method, requestUri, inputRecord, exchange);
        }
        catch (Throwable error) {
            this._log.warn((Object)("Error processing " + method + " " + requestUri), error);
            closeConnection = this.writeErrorResult(exchange, error, inputRecord);
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                closeConnection = this.writeSuccessResult(exchange, resultObject, inputRecord);
            }
            catch (IOException ex) {
                this._log.warn((Object)"Error writing the response. Maybe client has closed the connection.", (Throwable)ex);
                closeConnection = true;
                try {
                    if (closeConnection) {
                        IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                    }
                    exchange.getResponseStream().flush();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (closeConnection) {
                IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
            } else {
                exchange.getResponseStream().flush();
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method);
    }

    protected boolean writeSuccessResult(HttpExchange exchange, Object resultObject, Record inputRecord) throws IOException {
        int statusCode = this.getSuccessStatus(exchange.getRequestMethod(), exchange.getRequestURI(), inputRecord, resultObject);
        boolean closeConnection = HTTP_UTILS.prepareResponseHeader(exchange, statusCode, resultObject != null);
        this.writeResultObject(exchange.getResponseStream(), resultObject);
        return closeConnection;
    }

    protected int getSuccessStatus(String method, String requestUri) {
        return 200;
    }

    protected int getSuccessStatus(String requestMethod, String requestUri, Record inputRecord, Object resultObject) {
        return this.getSuccessStatus(requestMethod, requestUri);
    }

    protected void writeResultObject(OutputStream responseStream, Object resultObject) throws IOException {
        HTTP_UTILS.writeResultObject(responseStream, resultObject);
    }

    protected boolean writeErrorResult(HttpExchange exchange, Throwable error, Record inputRecord) throws IOException {
        int errorCode = this.getErrorStatus(exchange.getRequestMethod(), exchange.getRequestMethod(), error);
        boolean writeErrorDetails = !"HEAD".equals(exchange.getRequestMethod());
        boolean closeConnection = HTTP_UTILS.prepareResponseHeader(exchange, errorCode, writeErrorDetails);
        if (writeErrorDetails) {
            HTTP_UTILS.writeErrorDetails(exchange, error);
        }
        return closeConnection;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        return HTTP_UTILS.getErrorStatus(ex);
    }

    protected String getRequestHost(HttpExchange exchange) {
        if (exchange != null) {
            return exchange.getRequestHeader(HEADER_REQUEST_HOST);
        }
        return null;
    }
}

