/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.Properties;
import org.apache.ode.axis2.httpbinding.HttpBindingValidator;
import org.apache.ode.axis2.httpbinding.HttpHelper;
import org.apache.ode.axis2.httpbinding.HttpMethodConverter;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.il.epr.EndpointFactory;
import org.apache.ode.il.epr.MutableEndpoint;
import org.apache.ode.il.epr.WSAEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HttpExternalService
implements ExternalService {
    private static final Log log = LogFactory.getLog(HttpExternalService.class);
    private static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    private MultiThreadedHttpConnectionManager connections;
    protected BpelServer server;
    protected ProcessConf pconf;
    protected QName serviceName;
    protected String portName;
    protected HttpMethodConverter httpMethodConverter;
    protected WSAEndpoint endpointReference;
    protected Binding portBinding;

    public HttpExternalService(ProcessConf processConf, QName qName, String string, BpelServer bpelServer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new HTTP External service, service name=[" + qName + "]; port name=[" + string + "]"));
        }
        this.portName = string;
        this.serviceName = qName;
        this.server = bpelServer;
        this.pconf = processConf;
        Definition definition = processConf.getDefinitionForService(qName);
        Service service = definition.getService(qName);
        if (service == null) {
            throw new IllegalArgumentException(msgs.msgServiceDefinitionNotFound(qName));
        }
        Port port = service.getPort(string);
        if (port == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(qName, string));
        }
        this.portBinding = port.getBinding();
        if (this.portBinding == null) {
            throw new IllegalArgumentException(msgs.msgBindingNotFound(string));
        }
        if (!WsdlUtils.useHTTPBinding((Port)port)) {
            throw new IllegalArgumentException(msgs.msgNoHTTPBindingForPort(string));
        }
        new HttpBindingValidator(this.portBinding).validate();
        Element element = ODEService.genEPRfromWSDL(definition, qName, string);
        if (element == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(qName, string));
        }
        this.endpointReference = EndpointFactory.convertToWSA((MutableEndpoint)ODEService.createServiceRef(element));
        this.httpMethodConverter = new HttpMethodConverter(definition, qName, string);
        this.connections = new MultiThreadedHttpConnectionManager();
    }

    public String getPortName() {
        return this.portName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void close() {
        this.connections.shutdown();
    }

    public EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void invoke(PartnerRoleMessageExchange partnerRoleMessageExchange) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Preparing " + this.getClass().getSimpleName() + " invocation..."));
        }
        try {
            boolean bl;
            Map map = this.pconf.getEndpointProperties((EndpointReference)this.endpointReference);
            HttpParams httpParams = Properties.HttpClient.translate(map);
            HttpMethod httpMethod = this.httpMethodConverter.createHttpRequest(partnerRoleMessageExchange, httpParams);
            HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connections);
            Element element = DOMUtils.findChildByName((Element)partnerRoleMessageExchange.getRequest().getMessage(), (QName)new QName(null, "WWW-Authenticate"));
            HttpHelper.configure(httpClient, httpMethod.getURI(), element, httpParams);
            boolean bl2 = bl = partnerRoleMessageExchange.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
            if (bl) {
                TwoWayCallable twoWayCallable = new TwoWayCallable(httpClient, httpMethod, partnerRoleMessageExchange);
                twoWayCallable.call();
            } else {
                OneWayCallable oneWayCallable = new OneWayCallable(httpClient, httpMethod, partnerRoleMessageExchange);
                oneWayCallable.call();
                partnerRoleMessageExchange.replyOneWayOk();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = "The returned HTTP encoding isn't supported " + partnerRoleMessageExchange;
            log.error((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + partnerRoleMessageExchange.getOperationName() + "] " + string), (Throwable)unsupportedEncodingException);
            partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, string, null);
        }
        catch (URIException uRIException) {
            String string = "Invalid URI " + partnerRoleMessageExchange;
            log.error((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + partnerRoleMessageExchange.getOperationName() + "] " + string), (Throwable)uRIException);
            partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, string, null);
        }
        catch (Exception exception) {
            String string = "Unknown HTTP call error for ODE mex " + partnerRoleMessageExchange;
            log.error((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + partnerRoleMessageExchange.getOperationName() + "] " + string), (Throwable)exception);
            partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.OTHER, string, null);
        }
    }

    private class TwoWayCallable
    extends OneWayCallable {
        public TwoWayCallable(HttpClient httpClient, HttpMethod httpMethod, PartnerRoleMessageExchange partnerRoleMessageExchange) {
            super(httpClient, httpMethod, partnerRoleMessageExchange);
        }

        public void processResponse(int n) {
            try {
                if (n >= 200 && n < 300) {
                    this._2xx_success();
                } else if (n >= 300 && n < 400) {
                    this._3xx_redirection();
                } else if (n >= 400 && n < 600) {
                    this._4xx_5xx_error();
                } else {
                    this.unmanagedStatus();
                }
            }
            catch (Exception exception) {
                this.replyWithFailure("Exception occured while processing the HTTP response of a two-way request. mexId= " + this.odeMex.getMessageExchangeId(), exception);
            }
        }

        private void unmanagedStatus() throws Exception {
            this.replyWithFailure("Unmanaged Status Code! Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI());
        }

        private void _4xx_5xx_error() throws Exception {
            int n = this.method.getStatusCode();
            if (HttpHelper.isFaultOrFailure(n) > 0) {
                this.replyWithFault();
            } else {
                this.replyWithFailure("HTTP Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI());
            }
        }

        private void _3xx_redirection() throws Exception {
            this.replyWithFailure("Redirections disabled! HTTP Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI());
        }

        private void _2xx_success() throws Exception {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.odeMex.getOperationName() + "] HTTP Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received response for MEX " + this.odeMex));
            }
            Operation operation = this.odeMex.getOperation();
            QName qName = this.odeMex.getOperation().getOutput().getMessage().getQName();
            Message message = this.odeMex.createMessage(qName);
            HttpExternalService.this.httpMethodConverter.parseHttpResponse(message, this.method, operation);
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Response: " + (message.getMessage() != null ? DOMUtils.domToString((Node)message.getMessage()) : "empty")));
                }
                this.odeMex.reply(message);
            }
            catch (Exception exception) {
                this.replyWithFailure("Unable to process response: " + exception.getMessage(), exception);
            }
        }

        void replyWithFault() {
            Object[] objectArray = HttpExternalService.this.httpMethodConverter.parseFault(this.odeMex, this.method);
            Message message = (Message)objectArray[1];
            QName qName = (QName)objectArray[0];
            if (log.isWarnEnabled()) {
                log.warn((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.odeMex.getOperationName() + "] Fault response: faultName=" + qName + " faultType=" + message.getType() + "\n" + DOMUtils.domToString((Node)message.getMessage())));
            }
            this.odeMex.replyWithFault(qName, message);
        }

        void replyWithFailure(String string) {
            this.replyWithFailure(string, null);
        }

        void replyWithFailure(String string, Throwable throwable) {
            log.error((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.odeMex.getOperationName() + "] " + string), throwable);
            this.odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, string, HttpHelper.prepareDetailsElement(this.method));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OneWayCallable
    implements Callable<Void> {
        HttpMethod method;
        PartnerRoleMessageExchange odeMex;
        HttpClient client;

        public OneWayCallable(HttpClient httpClient, HttpMethod httpMethod, PartnerRoleMessageExchange partnerRoleMessageExchange) {
            this.method = httpMethod;
            this.odeMex = partnerRoleMessageExchange;
            this.client = httpClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing http request : " + this.method.getName() + " " + this.method.getURI()));
                    log.debug((Object)HttpHelper.requestToString(this.method));
                }
                int n = this.client.executeMethod(this.method);
                byte[] byArray = this.method.getResponseBody();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received response for MEX " + this.odeMex));
                    log.debug((Object)HttpHelper.responseToString(this.method));
                }
                this.processResponse(n);
            }
            catch (IOException iOException) {
                try {
                    String string = "Unable to execute HTTP request : " + iOException.getMessage();
                    log.error((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.odeMex.getOperationName() + "] " + string), (Throwable)iOException);
                    this.odeMex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, string, null);
                }
                catch (Exception exception) {
                    String string = "[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.odeMex.getOperationName() + "] Error executing reply transaction; reply will be lost.";
                    log.error((Object)string, (Throwable)iOException);
                }
            }
            finally {
                this.method.releaseConnection();
            }
            return null;
        }

        public void processResponse(int n) {
            try {
                if (n >= 400) {
                    log.error((Object)("OneWay HTTP Request failed, Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI()));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("OneWay HTTP Request, Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI()));
                }
            }
            catch (URIException uRIException) {
                String string = "[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.odeMex.getOperationName() + "] Exception occured while processing the HTTP response of a one-way request: " + uRIException.getMessage();
                log.error((Object)string, (Throwable)uRIException);
            }
        }
    }
}

