/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.dbutil;

import java.io.File;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.resource.spi.ConnectionManager;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.DatabaseConfigException;
import org.apache.ode.il.dbutil.Messages;
import org.apache.ode.utils.LoggingInterceptor;
import org.tranql.connector.jdbc.JDBCDriverMCF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static final Log __log = LogFactory.getLog(Database.class);
    private static final Log __logSql = LogFactory.getLog((String)"org.apache.ode.sql");
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private static final int CONNECTION_MAX_WAIT_MILLIS = 30000;
    private static final int CONNECTION_MAX_IDLE_MINUTES = 5;
    private OdeConfigProperties _odeConfig;
    private boolean _started;
    private GenericConnectionManager _connectionManager;
    private TransactionManager _txm;
    private DataSource _datasource;
    private File _workRoot;
    private boolean _needDerbyShutdown;
    private String _derbyUrl;

    public Database(OdeConfigProperties odeConfigProperties) {
        if (odeConfigProperties == null) {
            throw new NullPointerException("Must provide a configuration.");
        }
        this._odeConfig = odeConfigProperties;
    }

    public void setWorkRoot(File file) {
        this._workRoot = file;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this._txm = transactionManager;
    }

    public synchronized void start() throws DatabaseConfigException {
        if (this._started) {
            return;
        }
        this._needDerbyShutdown = false;
        this._datasource = null;
        this._connectionManager = null;
        this.initDataSource();
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (!this._started) {
            return;
        }
        if (this._connectionManager != null) {
            try {
                __log.debug((Object)"Stopping connection manager");
                this._connectionManager.doStop();
            }
            catch (Throwable throwable) {
                __log.warn((Object)("Exception while stopping connection manager: " + throwable.getMessage()));
            }
            finally {
                this._connectionManager = null;
            }
        }
        if (this._needDerbyShutdown) {
            __log.debug((Object)"shutting down derby.");
            EmbeddedDriver embeddedDriver = new EmbeddedDriver();
            try {
                embeddedDriver.connect(this._derbyUrl + ";shutdown=true", new Properties());
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 45000) {
                    __log.error((Object)("Error shutting down Derby: " + sQLException.getErrorCode()), (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                __log.debug((Object)"Error shutting down Derby.", throwable);
            }
        }
        this._needDerbyShutdown = false;
        this._datasource = null;
        this._started = false;
    }

    public DataSource getDataSource() {
        return __logSql.isDebugEnabled() ? LoggingInterceptor.createLoggingDS((DataSource)this._datasource, (Log)__logSql) : this._datasource;
    }

    private void initDataSource() throws DatabaseConfigException {
        switch (this._odeConfig.getDbMode()) {
            case EXTERNAL: {
                this.initExternalDb();
                break;
            }
            case EMBEDDED: {
                this.initEmbeddedDb();
                break;
            }
            case INTERNAL: {
                this.initInternalDb();
                break;
            }
        }
    }

    private void initExternalDb() throws DatabaseConfigException {
        try {
            this._datasource = (DataSource)this.lookupInJndi(this._odeConfig.getDbDataSource());
            __log.info((Object)__msgs.msgOdeUsingExternalDb(this._odeConfig.getDbDataSource()));
        }
        catch (Exception exception) {
            String string = __msgs.msgOdeInitExternalDbFailed(this._odeConfig.getDbDataSource());
            __log.error((Object)string, (Throwable)exception);
            throw new DatabaseConfigException(string, exception);
        }
    }

    private void initInternalDb() throws DatabaseConfigException {
        __log.info(__msgs.msgOdeUsingInternalDb(this._odeConfig.getDbIntenralJdbcUrl(), this._odeConfig.getDbInternalJdbcDriverClass()));
        this.initInternalDb(this._odeConfig.getDbIntenralJdbcUrl(), this._odeConfig.getDbInternalJdbcDriverClass(), this._odeConfig.getDbInternalUserName(), this._odeConfig.getDbInternalPassword());
    }

    private void initInternalDb(String string, String string2, String string3, String string4) throws DatabaseConfigException {
        __log.debug((Object)("Creating connection pool for " + string + " with driver " + string2));
        if (!(this._txm instanceof RecoverableTransactionManager)) {
            throw new RuntimeException("TransactionManager is not recoverable.");
        }
        TransactionSupport transactionSupport = LocalTransactions.INSTANCE;
        ConnectionTrackingCoordinator connectionTrackingCoordinator = new ConnectionTrackingCoordinator();
        SinglePool singlePool = new SinglePool(this._odeConfig.getPoolMaxSize(), this._odeConfig.getPoolMinSize(), 30000, 5, true, false, false);
        this._connectionManager = new GenericConnectionManager(transactionSupport, (PoolingSupport)singlePool, null, (ConnectionTracker)connectionTrackingCoordinator, (RecoverableTransactionManager)this._txm, this.getClass().getName(), this.getClass().getClassLoader());
        JDBCDriverMCF jDBCDriverMCF = new JDBCDriverMCF();
        try {
            jDBCDriverMCF.setDriver(string2);
            jDBCDriverMCF.setConnectionURL(string);
            if (string3 != null) {
                jDBCDriverMCF.setUserName(string3);
            }
            if (string4 != null) {
                jDBCDriverMCF.setPassword(string4);
            }
            this._connectionManager.doStart();
            this._datasource = (DataSource)jDBCDriverMCF.createConnectionFactory((ConnectionManager)this._connectionManager);
        }
        catch (Exception exception) {
            String string5 = __msgs.msgOdeDbPoolStartupFailed(string);
            __log.error((Object)string5, (Throwable)exception);
            throw new DatabaseConfigException(string5, exception);
        }
    }

    private void initEmbeddedDb() throws DatabaseConfigException {
        String string = this._odeConfig.getDbEmbeddedName();
        String string2 = "jdbc:derby:" + this._workRoot + "/" + string;
        __log.info((Object)("Using Embedded Derby: " + string2));
        this._derbyUrl = string2;
        this.initInternalDb(string2, EmbeddedDriver.class.getName(), "sa", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T lookupInJndi(String string) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Object object;
            block11: {
                InitialContext initialContext = null;
                try {
                    initialContext = new InitialContext();
                    object = initialContext.lookup(string);
                    if (initialContext == null) break block11;
                }
                catch (Throwable throwable) {
                    if (initialContext != null) {
                        try {
                            initialContext.close();
                        }
                        catch (Exception exception) {
                            __log.error((Object)"Error closing JNDI connection.", (Throwable)exception);
                        }
                    }
                    throw throwable;
                }
                try {
                    initialContext.close();
                }
                catch (Exception exception) {
                    __log.error((Object)"Error closing JNDI connection.", (Throwable)exception);
                }
            }
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public BpelDAOConnectionFactoryJDBC createDaoCF() throws DatabaseConfigException {
        BpelDAOConnectionFactoryJDBC bpelDAOConnectionFactoryJDBC;
        String string = this._odeConfig.getDAOConnectionFactory();
        __log.info((Object)__msgs.msgOdeUsingDAOImpl(string));
        try {
            bpelDAOConnectionFactoryJDBC = (BpelDAOConnectionFactoryJDBC)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            String string2 = __msgs.msgDAOInstantiationFailed(string);
            __log.error((Object)string2, (Throwable)exception);
            throw new DatabaseConfigException(string2, exception);
        }
        bpelDAOConnectionFactoryJDBC.setDataSource(this.getDataSource());
        bpelDAOConnectionFactoryJDBC.setTransactionManager((Object)this._txm);
        bpelDAOConnectionFactoryJDBC.init(this._odeConfig.getProperties());
        return bpelDAOConnectionFactoryJDBC;
    }
}

