/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.util;

import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

public final class HttpClientUtil {
    private HttpClientUtil() {
    }

    public static HttpClient createInstance() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpClientUtil.disableRetries(client);
        return client;
    }

    public static HttpClient createInstance(ClientConnectionManager connectionManager) {
        DefaultHttpClient client = new DefaultHttpClient(connectionManager);
        HttpClientUtil.disableRetries(client);
        return client;
    }

    private static void disableRetries(DefaultHttpClient client) {
        DefaultHttpRequestRetryHandler retryhandler = new DefaultHttpRequestRetryHandler(0, false);
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)retryhandler);
    }

    public static ClientConnectionManager createThreadSafeConnectionManager() {
        return new ThreadSafeClientConnManager();
    }

    public static ClientConnectionManager createThreadSafeConnectionManager(int maxTotalConnections, int maxConnectionsPerHost) {
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager();
        manager.setMaxTotal(maxTotalConnections);
        manager.setDefaultMaxPerRoute(maxConnectionsPerHost);
        return manager;
    }
}

