/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.bom;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.SourceLocation;
import org.apache.ode.bpel.compiler.bom.BpelObjectFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelObject
extends SourceLocation {
    public static final QName ATTR_LINENO = new QName("urn:org.apache.ode.bpel.compiler", "lineno");
    private final Element _element;
    private final QName _type;
    private final NSContext _nsContext;
    private List<BpelObject> _children = null;
    private URI _docURI;

    public BpelObject(Element element) {
        this._element = element;
        this._type = new QName(element.getNamespaceURI(), element.getLocalName());
        this._nsContext = new NSContext();
        this.initNSContext(element);
    }

    public QName getType() {
        return this._type;
    }

    public Element getElement() {
        return this._element;
    }

    @Override
    public int getLineNo() {
        return Integer.valueOf(this.getAttribute(ATTR_LINENO, "-1"));
    }

    public NSContext getNamespaceContext() {
        return this._nsContext;
    }

    public Map<QName, Object> getExtensibilityElements() {
        HashMap<QName, Object> hashMap = new HashMap<QName, Object>();
        for (BpelObject bpelObject : this.getChildren()) {
            if (bpelObject.getType().getNamespaceURI() == null || bpelObject.getType().getNamespaceURI().equals(this.getType().getNamespaceURI())) continue;
            hashMap.put(bpelObject.getType(), bpelObject.getElement());
        }
        NamedNodeMap namedNodeMap = this.getElement().getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNamespaceURI() == null || node.getNamespaceURI().equals(this.getType().getNamespaceURI())) continue;
            hashMap.put(new QName(node.getNamespaceURI(), node.getLocalName()), node.getTextContent());
        }
        return hashMap;
    }

    public Element getExtensibilityElement(QName qName) {
        BpelObject bpelObject = this.getFirstChild(qName);
        if (bpelObject == null) {
            return null;
        }
        return bpelObject.getElement();
    }

    public Element getFirstExtensibilityElement() {
        Element element = null;
        NodeList nodeList = this.getElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || this.getType().getNamespaceURI().equals(node.getNamespaceURI())) continue;
            element = (Element)node;
            break;
        }
        return element;
    }

    public boolean is11() {
        return this.getType().getNamespaceURI() != null && (this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2003/03/business-process/") || this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2003/05/partner-link/"));
    }

    public boolean is20Draft() {
        return this.getType().getNamespaceURI() != null && (this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/partner-link/"));
    }

    protected boolean isAttributeSet(String string) {
        return null != this.getAttribute(string, null);
    }

    protected <T extends BpelObject> List<T> getChildren(Class<T> clazz) {
        return (List)CollectionsX.filter(new ArrayList(), this.getChildren(), clazz);
    }

    protected <T extends BpelObject> T getFirstChild(Class<T> clazz) {
        List<T> list = this.getChildren(clazz);
        if (list.size() == 0) {
            return null;
        }
        return (T)((BpelObject)list.get(0));
    }

    protected List<BpelObject> getChildren(final QName qName) {
        return (List)CollectionsX.filter(new ArrayList(), this.getChildren(), (MemberOfFunction)new MemberOfFunction<BpelObject>(){

            public boolean isMember(BpelObject bpelObject) {
                return bpelObject.getType().equals(qName);
            }
        });
    }

    protected BpelObject getFirstChild(final QName qName) {
        return (BpelObject)CollectionsX.find_if(this.getChildren(), (MemberOfFunction)new MemberOfFunction<BpelObject>(){

            public boolean isMember(BpelObject bpelObject) {
                return bpelObject.getType().equals(qName);
            }
        });
    }

    protected QName rewriteTargetNS(QName qName) {
        return new QName(this.getType().getNamespaceURI(), qName.getLocalPart());
    }

    protected List<BpelObject> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<BpelObject>();
            NodeList nodeList = this._element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                this._children.add(this.createBpelObject((Element)node));
            }
        }
        return this._children;
    }

    protected BpelObject createBpelObject(Element element) {
        return BpelObjectFactory.getInstance().createBpelObject(element, this._docURI);
    }

    protected String getAttribute(QName qName, String string) {
        String string2 = this._element.getAttributeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (string2 == null || "".equals(string2)) {
            return string;
        }
        return string2;
    }

    protected String getAttribute(String string, String string2) {
        String string3 = this._element.getAttribute(string);
        if (string3 == null || "".equals(string3)) {
            return string2;
        }
        return string3;
    }

    protected String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    protected <T> T getAttribute(String string, Map<String, T> map, T t) {
        String string2 = this.getAttribute(string, null);
        if (string2 == null || "".equals(string2)) {
            return t;
        }
        return map.get(string2);
    }

    private void initNSContext(Element element) {
        if (element.getParentNode() != null && element.getParentNode().getNodeType() == 1) {
            this.initNSContext((Element)element.getParentNode());
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            String string = attr.getLocalName();
            String string2 = attr.getValue();
            this._nsContext.register(string, string2);
        }
        Attr attr = element.getAttributeNode("xmlns");
        if (attr != null) {
            this._nsContext.register("", attr.getTextContent());
        }
    }

    public String getTextValue() {
        this.getElement().normalize();
        for (Node node = this.getElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: 
                case 3: 
                case 4: {
                    return node.getNodeValue();
                }
            }
        }
        return null;
    }

    public String toString() {
        return DOMUtils.domToString((Node)this._element);
    }

    @Override
    public int getColumnNo() {
        return 0;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public URI getURI() {
        return this._docURI;
    }

    public void setURI(URI uRI) {
        this._docURI = uRI;
    }
}

