/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1.xpath10;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.SourceLocatorWrapper;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.v1.CompilerContext;

public class XslCompilationErrorListener
implements ErrorListener {
    private static final Log __log = LogFactory.getLog(XslCompilationErrorListener.class);
    private CompilerContext _cc;

    public XslCompilationErrorListener(CompilerContext compilerContext) {
        this._cc = compilerContext;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        if (__log.isWarnEnabled()) {
            __log.warn((Object)transformerException);
        }
        this.recover((short)1, transformerException);
    }

    public void error(TransformerException transformerException) throws TransformerException {
        if (__log.isErrorEnabled()) {
            __log.error((Object)transformerException);
        }
        this.recover((short)2, transformerException);
        throw transformerException;
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        if (__log.isFatalEnabled()) {
            __log.fatal((Object)transformerException);
        }
        this.recover((short)2, transformerException);
        throw transformerException;
    }

    private void recover(short s, TransformerException transformerException) {
        SourceLocatorWrapper sourceLocatorWrapper;
        CompilationMessage compilationMessage = new CompilationMessage();
        compilationMessage.severity = s;
        compilationMessage.code = "parseXsl";
        compilationMessage.phase = 0;
        compilationMessage.messageText = transformerException.getMessageAndLocation();
        CompilationException compilationException = new CompilationException(compilationMessage, (Throwable)transformerException);
        SourceLocatorWrapper sourceLocatorWrapper2 = sourceLocatorWrapper = transformerException.getLocator() != null ? new SourceLocatorWrapper(transformerException.getLocator()) : null;
        if (this._cc != null) {
            this._cc.recoveredFromError(sourceLocatorWrapper, compilationException);
        } else {
            __log.error((Object)"XSL stylesheet parsing error! ", (Throwable)transformerException);
        }
    }
}

