/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.feed;

import java.util.Collection;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.crawler.feed.FeedCrawlingContext;
import org.eclipse.smila.importing.crawler.feed.FeedProperties;
import org.eclipse.smila.importing.crawler.feed.RomeFeedReader;
import org.eclipse.smila.importing.util.RecordOutputHandler;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;

public class FeedCrawlerWorker
implements Worker {
    public static final String NAME = "feedCrawler";
    public static final String OUTPUT_SLOT_CRAWLED_RECORDS = "crawledRecords";
    public static final String TASK_PARAM_FEED_URL = "feedUrls";
    public static final String TASK_PARAM_MAX_RECORDS_PER_BULK = "maxRecordsPerBulk";
    public static final String TASK_PARAM_DELTA_PROPERTIES = "deltaProperties";
    public static final Long MAX_RECORDS_PER_BULK_DEFAULT = 1000L;
    private final Log _log = LogFactory.getLog(this.getClass());

    public String getName() {
        return NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        FeedCrawlingContext crawlContext = new FeedCrawlingContext(taskContext);
        RecordOutputHandler recordOutput = new RecordOutputHandler(taskContext.getOutputs(), crawlContext.getMaxRecordsPerBulk(), OUTPUT_SLOT_CRAWLED_RECORDS);
        String errorMessage = "";
        boolean success = false;
        for (Any url : crawlContext.getFeedUrls()) {
            String feedUrl = url.toString();
            try {
                this.crawl(crawlContext, feedUrl, recordOutput);
                success = true;
            }
            catch (Exception e) {
                String m = "Error while crawling feed '" + feedUrl + "': " + e.getMessage() + ". ";
                this._log.warn((Object)m);
                errorMessage = String.valueOf(errorMessage) + m;
            }
        }
        if (!success) {
            throw new ImportingException(errorMessage);
        }
    }

    private void crawl(FeedCrawlingContext crawlContext, String feedUrl, RecordOutputHandler recordOutput) throws Exception {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Crawling feed " + feedUrl));
        }
        RomeFeedReader feedReader = new RomeFeedReader();
        Collection<Record> results = feedReader.readFeed(feedUrl);
        for (Record record : results) {
            this.augmentRecord(crawlContext, feedUrl, record);
            crawlContext.getMapper().mapNames(record, FeedProperties.ALL_PROPS);
            recordOutput.writeRecord(record);
        }
    }

    private Record augmentRecord(FeedCrawlingContext crawlContext, String feedUrl, Record record) throws ImportingException {
        record.setId(this.createId(crawlContext, record));
        record.setSource(crawlContext.getDataSource());
        record.getMetadata().put("_deltaHash", this.createDeltaHash(crawlContext, record));
        return record;
    }

    private String createId(FeedCrawlingContext crawlContext, Record record) throws ImportingException {
        String feedEntryUri = record.getMetadata().getStringValue("itemUri");
        return String.valueOf(crawlContext.getDataSource()) + ":" + feedEntryUri;
    }

    private String createDeltaHash(FeedCrawlingContext crawlContext, Record record) throws ImportingException {
        Any deltaProps = crawlContext.getDeltaProperties();
        if (deltaProps == null) {
            return UUID.randomUUID().toString();
        }
        StringBuilder deltaBuilder = new StringBuilder();
        boolean success = false;
        for (Any propAny : deltaProps) {
            String prop = propAny.toString();
            if (record.getMetadata().containsKey((Object)prop)) {
                Value any = record.getMetadata().getValue(prop);
                if (any.isValue()) {
                    deltaBuilder.append(any.asValue().asString());
                    success = true;
                    continue;
                }
                this._log.warn((Object)("Couldn't create delta hash, property '" + prop + "' has no simple value, value type is " + any.getValueType() + ". Forcing update."));
                continue;
            }
            this._log.warn((Object)("Couldn't create delta hash, property '" + prop + "' wasn't set. Forcing update."));
        }
        if (!success) {
            return UUID.randomUUID().toString();
        }
        return deltaBuilder.toString();
    }
}

