/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.filter;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.util.RegexPatternMatcher;

public class FilterConfiguration {
    public static final String MAX_SIZE = "maxFileSize";
    public static final String MAX_DEPTH = "maxFolderDepth";
    public static final String SYMBOLIC_LINKS = "followSymbolicLinks";
    public static final String FILE_PATTERNS = "filePatterns";
    public static final String FOLDER_PATTERNS = "folderPatterns";
    public static final String INCLUDE_PATTERNS = "include";
    public static final String EXCLUDE_PATTERNS = "exclude";
    private final RegexPatternMatcher _fileMatcher = new RegexPatternMatcher();
    private final RegexPatternMatcher _folderMatcher = new RegexPatternMatcher();
    private long _maxSize = Long.MAX_VALUE;
    private long _maxDepth = Long.MAX_VALUE;
    private boolean _symbolicLinks;

    public FilterConfiguration(AnyMap filterConfig) {
        if (filterConfig.containsKey((Object)MAX_SIZE)) {
            this._maxSize = filterConfig.getLongValue(MAX_SIZE);
        }
        if (filterConfig.containsKey((Object)MAX_DEPTH)) {
            this._maxDepth = filterConfig.getLongValue(MAX_DEPTH);
        }
        if (filterConfig.containsKey((Object)SYMBOLIC_LINKS)) {
            this._symbolicLinks = filterConfig.getBooleanValue(SYMBOLIC_LINKS);
        }
        this.initPatternMatcher(filterConfig, FILE_PATTERNS, this._fileMatcher);
        this.initPatternMatcher(filterConfig, FOLDER_PATTERNS, this._folderMatcher);
    }

    private void initPatternMatcher(AnyMap filterConfig, String patternKey, RegexPatternMatcher patternMatcher) {
        if (filterConfig.containsKey((Object)patternKey)) {
            AnyMap patterns = filterConfig.getMap(patternKey);
            if (patterns.containsKey((Object)INCLUDE_PATTERNS)) {
                Any includes = (Any)patterns.get((Object)INCLUDE_PATTERNS);
                for (Any include : includes) {
                    if (!include.isValue()) continue;
                    patternMatcher.addIncludePattern(include.asValue().asString());
                }
            }
            if (patterns.containsKey((Object)EXCLUDE_PATTERNS)) {
                Any excludes = (Any)patterns.get((Object)EXCLUDE_PATTERNS);
                for (Any exclude : excludes) {
                    if (!exclude.isValue()) continue;
                    patternMatcher.addExcludePattern(exclude.asValue().asString());
                }
            }
        }
    }

    public long getMaxSize() {
        return this._maxSize;
    }

    public long getMaxDepth() {
        return this._maxDepth;
    }

    public boolean followSymbolicLinks() {
        return this._symbolicLinks;
    }

    public RegexPatternMatcher getFilePatternMatcher() {
        return this._fileMatcher;
    }

    public RegexPatternMatcher getFolderPatternMatcher() {
        return this._folderMatcher;
    }
}

