/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.filter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.importing.crawler.file.filter.FilterConfiguration;
import org.eclipse.smila.importing.util.FilePathNormalizer;

public class FilterEvaluator {
    private FilterConfiguration _filterConfig;

    public Collection<File> applyFiltersForCrawledFiles(File fileDir, Collection<File> files) throws IOException {
        ArrayList<File> result = new ArrayList<File>(files);
        if (this._filterConfig != null) {
            String normalizedFileDir = this.normalize(fileDir);
            Iterator it = result.iterator();
            while (it.hasNext()) {
                File f = (File)it.next();
                if (!this._filterConfig.getFilePatternMatcher().matches(f.getName())) {
                    it.remove();
                    continue;
                }
                if (f.length() > this._filterConfig.getMaxSize()) {
                    it.remove();
                    continue;
                }
                if (!this._filterConfig.getFolderPatternMatcher().isIncluded(normalizedFileDir)) {
                    it.remove();
                    continue;
                }
                if (!FileUtils.isSymlink((File)f) || this._filterConfig.followSymbolicLinks()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean applyFiltersForCrawledFile(File fileDir, File file) throws IOException {
        return !this.applyFiltersForCrawledFiles(fileDir, Arrays.asList(file)).isEmpty();
    }

    public Collection<File> applyFiltersForCrawledFolders(Collection<File> folders, String rootFolder) throws IOException {
        ArrayList<File> result = new ArrayList<File>(folders);
        if (this._filterConfig != null) {
            String normalizedRoot = this.normalize(rootFolder);
            int rootDepth = StringUtils.countMatches((String)normalizedRoot, (String)"/");
            Iterator it = result.iterator();
            while (it.hasNext()) {
                File dir = (File)it.next();
                String normalizedPath = this.normalize(dir);
                int depth = StringUtils.countMatches((String)normalizedPath, (String)"/") - rootDepth;
                if ((long)depth > this._filterConfig.getMaxDepth()) {
                    it.remove();
                    continue;
                }
                if (this._filterConfig.getFolderPatternMatcher().isExcluded(normalizedPath)) {
                    it.remove();
                    continue;
                }
                if (!FileUtils.isSymlink((File)dir) || this._filterConfig.followSymbolicLinks()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean applyFiltersForCrawledFolder(File folder, String rootFolder) throws IOException {
        return !this.applyFiltersForCrawledFolders(Arrays.asList(folder), rootFolder).isEmpty();
    }

    private String normalize(File input) {
        return FilePathNormalizer.getNormalizedPath((File)input);
    }

    private String normalize(String input) {
        return FilePathNormalizer.getNormalizedPath((String)input);
    }

    public void setFilterConfiguration(FilterConfiguration filterConfig) {
        this._filterConfig = filterConfig;
    }
}

