/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainEndResultTransformer
implements EndResultTransformer {
    @Override
    public void transform(Map<String, ?> result, SolrQueryResponse response, GroupingSpecification groupingSpecification, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        Object value = result.get(groupingSpecification.getFields()[0]);
        if (TopGroups.class.isInstance(value)) {
            TopGroups topGroups = (TopGroups)value;
            SolrDocumentList docList = new SolrDocumentList();
            docList.setStart((long)groupingSpecification.getOffset());
            docList.setNumFound((long)topGroups.totalHitCount);
            Float maxScore = Float.valueOf(Float.NEGATIVE_INFINITY);
            for (GroupDocs group : topGroups.groups) {
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    if (maxScore.floatValue() < scoreDoc.score) {
                        maxScore = Float.valueOf(scoreDoc.score);
                    }
                    docList.add((Object)solrDocumentSource.retrieve(scoreDoc));
                }
            }
            if (maxScore.floatValue() != Float.NEGATIVE_INFINITY) {
                docList.setMaxScore(maxScore);
            }
            response.add("response", docList);
        }
    }
}

