/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.config.ConfigurationLoadException;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;

public class SolrProperties {
    private static final String PROPERTIES = "solr.properties";
    public static final String PROP_EMBEDDED = "solr.embedded";
    public static final String PROP_WORKSPACE_FOLDER = "solr.workspaceFolder";
    public static final String PROP_SERVER_URL = "solr.serverUrl";
    public static final String DEFAULT_SERVER_URL = "http://localhost:8983/solr";
    private final Log _log = LogFactory.getLog(SolrProperties.class);
    private final Properties _properties;
    private File _configurationFolder;
    private File _workspaceFolder;

    public SolrProperties() {
        this(ConfigUtils.getConfigStream((String)"org.eclipse.smila.solr", (String)PROPERTIES));
    }

    public SolrProperties(Properties solrProps) {
        this._properties = solrProps;
    }

    public SolrProperties(InputStream configStream) {
        try {
            InputStream stream = configStream;
            this._properties = new Properties();
            this._properties.load(stream);
        }
        catch (Exception exception) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Error while loading solr properties", (Throwable)exception);
            }
            throw new ConfigurationLoadException("Error while loading solr properties", (Throwable)exception);
        }
    }

    public Boolean isEmbedded() {
        Boolean embedded = BooleanUtils.toBooleanObject((String)this._properties.getProperty(PROP_EMBEDDED));
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)embedded, (boolean)true);
    }

    public File getConfigurationFolder() {
        if (this._configurationFolder == null) {
            this._configurationFolder = ConfigUtils.getConfigFile((String)"org.eclipse.smila.solr", (String)"");
        }
        return this._configurationFolder;
    }

    public File getWorkspaceFolder() throws IOException {
        if (this._workspaceFolder == null) {
            String path = this._properties.getProperty(PROP_WORKSPACE_FOLDER);
            if (path != null) {
                this._workspaceFolder = new File(path);
                return this._workspaceFolder;
            }
            this._workspaceFolder = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.solr");
        }
        return this._workspaceFolder;
    }

    public String getServerUrl() {
        if (!this.isEmbedded().booleanValue()) {
            return StringUtils.defaultString((String)this._properties.getProperty(PROP_SERVER_URL), (String)DEFAULT_SERVER_URL);
        }
        return "No solr server url configured because server is embedded.";
    }
}

