/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class FilterPipelet
implements Pipelet {
    private static final String FILTER_ATTRIBUTE_PARAMETER = "filterAttribute";
    private static final String FILTER_EXPRESSION_PARAMETER = "filterExpression";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null && recordIds.length > 0) {
            ParameterAccessor parameters = new ParameterAccessor(blackboard, this._configuration);
            ResultCollector resultCollector = new ResultCollector(parameters, this._log, true);
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String recordId = stringArray[n2];
                try {
                    Record record = blackboard.getRecord(recordId);
                    if (record != null) {
                        parameters.setCurrentRecord(recordId);
                        String filterAttribute = parameters.getRequiredParameter(FILTER_ATTRIBUTE_PARAMETER);
                        String filterExpression = parameters.getRequiredParameter(FILTER_EXPRESSION_PARAMETER);
                        if (this.recordMatches(record, filterAttribute, filterExpression)) {
                            resultCollector.addResult(recordId);
                        }
                    } else if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Record " + recordId + " does not exist on blackboard."));
                    }
                }
                catch (BlackboardAccessException ex) {
                    this._log.warn((Object)("Record " + recordId + " not accessible"), (Throwable)ex);
                    resultCollector.addFailedResult(recordId, (Exception)((Object)ex));
                }
                catch (MissingParameterException ex) {
                    this._log.warn((Object)("Missing parameter for record " + recordId + ": " + (Object)((Object)ex)));
                    resultCollector.addFailedResult(recordId, (Exception)((Object)ex));
                }
                ++n2;
            }
            String[] matchingRecords = resultCollector.getResultIds();
            int matchingRecordsCount = matchingRecords.length;
            int droppedRecordsCount = recordIds.length - matchingRecordsCount;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Matched " + matchingRecordsCount + " records, dropped " + droppedRecordsCount + " records."));
            }
            return matchingRecords;
        }
        return recordIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean recordMatches(Record record, String filterAttribute, String filterExpression) {
        try {
            String valueToMatch = record.getMetadata().getStringValue(filterAttribute);
            if (valueToMatch == null) {
                if (!this._log.isDebugEnabled()) return false;
                this._log.debug((Object)("Record " + record.getId() + " does not have attribute " + filterAttribute + " set."));
                return false;
            }
            if (valueToMatch.matches(filterExpression)) {
                if (!this._log.isDebugEnabled()) return true;
                this._log.debug((Object)("Record " + record.getId() + ": " + filterAttribute + "=" + valueToMatch + " matches " + filterExpression));
                return true;
            }
            if (!this._log.isDebugEnabled()) return false;
            this._log.debug((Object)("Record " + record.getId() + ": " + filterAttribute + "=" + valueToMatch + " does not match " + filterExpression));
            return false;
        }
        catch (InvalidValueTypeException ex) {
            if (!this._log.isDebugEnabled()) return false;
            this._log.warn((Object)("Invalid value type in filter attribute " + filterAttribute + ": " + (Object)((Object)ex)));
            return false;
        }
        catch (PatternSyntaxException ex) {
            this._log.warn((Object)("Invalid pattern " + filterExpression + " for matching record " + record.getId() + ": " + ex));
        }
        return false;
    }
}

