/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.test;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.smila.utils.log.BundleLogHelper;
import org.eclipse.smila.utils.service.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public abstract class DeclarativeServiceTestCase
extends TestCase {
    protected static final int DEFAULT_SERVICE_MAX_WAITING = 60000;
    private static BundleContext s_bundleContext;
    protected final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Map<Class<?>, ServiceRegistration> _registeredServices = new HashMap();

    public static void setBundleContext(BundleContext bundleContext) {
        s_bundleContext = bundleContext;
    }

    @Deprecated
    protected Object getService(String clazz, long timeout) throws InterruptedException {
        Object service;
        ServiceReference reference = s_bundleContext.getServiceReference(clazz);
        if (reference != null && (service = s_bundleContext.getService(reference)) != null) {
            return service;
        }
        try (ServiceTracker st = null;){
            st = new ServiceTracker(s_bundleContext, clazz, null);
            st.open();
            st.waitForService(timeout);
            if (st.getService() == null) {
                String msg = "Unable to find service " + clazz;
                this._log.error((Object)msg);
                BundleLogHelper.logBundlesState();
                throw new RuntimeException(msg);
            }
            Object object = st.getService();
            return object;
        }
    }

    @Deprecated
    protected <T> T getService(Class<T> clazz, long timeout) throws InterruptedException {
        return (T)this.getService(clazz.getName(), timeout);
    }

    protected <T> T getService(Class<T> clazz) throws InterruptedException {
        return (T)this.getService(clazz.getName(), 60000L);
    }

    protected <T> T getService(Class<T> clazz, String filter, long timeout) throws InterruptedException {
        return (T)this.getService(clazz.getName(), filter, timeout);
    }

    protected <T> T getService(Class<T> clazz, String filter) throws InterruptedException {
        return (T)this.getService(clazz.getName(), filter, 60000L);
    }

    @Deprecated
    protected Object getService(String clazz, String filter, long timeout) throws InterruptedException {
        Object object;
        block8: {
            Object service;
            ServiceReference[] references = s_bundleContext.getServiceReferences(clazz, filter);
            if (references != null && (service = s_bundleContext.getService(references[0])) != null) {
                return service;
            }
            ServiceTracker st = null;
            try {
                Filter serviceFilter = s_bundleContext.createFilter(filter);
                st = new ServiceTracker(s_bundleContext, serviceFilter, null);
                st.open();
                st.waitForService(timeout);
                if (st.getService() == null) {
                    String msg = "Unable to find service " + clazz;
                    this._log.error((Object)msg);
                    BundleLogHelper.logBundlesState();
                    throw new RuntimeException(msg);
                }
                object = st.getService();
                if (st == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        st.close();
                    }
                    throw throwable;
                }
                catch (InvalidSyntaxException e) {
                    String msg = "Unable to find service " + clazz;
                    this._log.error((Object)msg);
                    BundleLogHelper.logBundlesState();
                    throw new RuntimeException(msg, e);
                }
            }
            st.close();
        }
        return object;
    }

    protected <T> T registerService(Object service, Dictionary<String, ?> properties, Class<T> clazz, long timeout) throws InterruptedException {
        ServiceRegistration sReg = s_bundleContext.registerService(clazz.getName(), service, properties);
        this._registeredServices.put(clazz, sReg);
        return this.getService(clazz, timeout);
    }

    protected void unregisterService(Class<?> clazz) throws InterruptedException {
        ServiceRegistration sReg = this._registeredServices.get(clazz);
        if (sReg != null) {
            sReg.unregister();
        }
    }

    protected URL resolveResourceURL(String relativePath) throws IOException {
        URL nativeUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(relativePath);
        URL url = FileLocator.resolve((URL)nativeUrl);
        return url;
    }

    protected static void assertServiceRegistered(Class<?> serviceInterface, Class<?> implementationClass) {
        ServiceReference[] refs = ServiceUtils.getServiceReferences(serviceInterface);
        Assert.assertNotNull((Object)refs);
        ServiceReference[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            Object service = ServiceUtils.getService((ServiceReference)ref, serviceInterface);
            if (service.getClass() == implementationClass) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)(String.valueOf(implementationClass.getName()) + " service not registered"));
    }
}

