/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.versions.internal;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.versions.VersionProvider;
import org.osgi.service.component.ComponentContext;

public class SmilaVersionProvider
implements VersionProvider {
    public static final String PROVIDER_NAME = "smila";
    private static final String BUNDLE_NAME = "org.eclipse.smila.versions";
    private static final String CONFIG_FILE_NAME = "version.properties";
    private final Log _log = LogFactory.getLog(this.getClass());
    private Properties _versionProps;

    @Override
    public AnyMap getVersionInfo() {
        AnyMap versionInfo = DataFactory.DEFAULT.createAnyMap();
        if (this._versionProps != null && !this._versionProps.isEmpty()) {
            for (Object key : this._versionProps.keySet()) {
                String componentName = key.toString();
                versionInfo.put(componentName, this._versionProps.getProperty(componentName));
            }
        } else {
            versionInfo.put(PROVIDER_NAME, "not available");
        }
        return versionInfo;
    }

    protected void activate(ComponentContext context) {
        try {
            Properties versionProps = ConfigUtils.getConfigProperties((String)BUNDLE_NAME, (String)CONFIG_FILE_NAME);
            this.setVersionProperties(versionProps);
        }
        catch (Exception e) {
            this._log.warn((Object)"Could not read version properties", (Throwable)e);
        }
    }

    public void setVersionProperties(Properties versionProps) {
        this._versionProps = versionProps;
    }
}

