/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.workermanager;

import org.eclipse.smila.datamodel.AnyMap;

import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;

/**
 * Administrates all (java) workers. Handles task get/finish/keepAlive and worker scale up.
 */
public interface WorkerManager {

  /** prefix for internal workers. */
  String PREFIX_INTERNAL = TaskManager.PREFIX_INTERNAL;

  /**
   * Returns whether the given worker was successfully registered.
   */
  boolean containsWorker(String worker);

  /**
   * @param scaleUpControl
   *          defines scale up limit for workers
   */
  void setScaleUpControl(final ScaleUpControl scaleUpControl);

  /**
   * @param listener
   *          Listener that wants to be informed about keep alive failures.
   */
  void addKeepAliveListener(TaskKeepAliveListener listener);

  /**
   * @param listener
   *          Listener that no longer wants to be informed about keep alive failures.
   */
  void removeKeepAliveListener(TaskKeepAliveListener listener);

  /**
   * @param task
   *          task to add under keep alive control
   */
  void addKeepAliveTask(Task task);

  /**
   * @param task
   *          task to remove from keep alive control
   */
  void removeKeepAliveTask(Task task);

  /**
   * @return workerManager info object.
   */
  AnyMap getInfo();

  /**
   * for testing.
   * 
   * @param keepAliveCheckMillis
   *          the time interval in ms after which we check if there are tasks for keep alive.
   * @param keepAliveSendSeconds
   *          the time interval in seconds after which keep alive is sent for a processed task
   */
  void setKeepAliveInterval(long keepAliveCheckMillis, long keepAliveSendSeconds);

}
