/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing;

import java.io.InputStream;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.taskworker.TaskContext;

/** interface for services that can fetch an input stream to a content object in a data source. */
public interface ContentFetcher {
  /**
   * get a stream on a content object. Make sure to close the stream after usage.
   * 
   * @param record
   *          a crawled record describing the content object.
   * @param taskContext
   *          the TaskContexrt containing job parameters and more
   * @return content stream
   * @throws ImportingException
   *           error accessing the content object.
   */
  InputStream getContent(final Record record, final TaskContext taskContext) throws ImportingException;
}
