/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing.crawler.web.utils;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.eclipse.smila.utils.config.ConfigUtils;

/**
 * Configuration for the web crawler.
 */
public class WebCrawlerConfiguration {
  /** the bundle name for the configuration. */
  private static final String BUNDLE_NAME = "org.eclipse.smila.importing.crawler.web";

  /** the name of the bundle's configuration file. */
  private static final String CONFIG_FILE_NAME = "webcrawler.properties";

  /** the name of the proxy host name. */
  private static final String PROPERTY_PROXY_HOST_NAME = "proxyHost";

  /** the name of the proxy host port. */
  private static final String PROPERTY_PROXY_HOST_PORT = "proxyPort";

  /** the name of the socket timeout parameter. */
  private static final String PROPERTY_SOCKET_TIMEOUT = "socketTimeout";

  /** local logger. */
  private final Log _log = LogFactory.getLog(getClass());

  /** the configured proxy host. */
  private HttpHost _proxyHost;

  /** socket timeout. */
  private Integer _socketTimeout = -1;

  /**
   * reads the configuration.
   */
  public WebCrawlerConfiguration() {
    try {
      final Properties webCrawlerProperties = ConfigUtils.getConfigProperties(BUNDLE_NAME, CONFIG_FILE_NAME);
      if (webCrawlerProperties.containsKey(PROPERTY_PROXY_HOST_NAME)) {
        if (webCrawlerProperties.containsKey(PROPERTY_PROXY_HOST_PORT)) {
          _proxyHost =
            new HttpHost(webCrawlerProperties.getProperty(PROPERTY_PROXY_HOST_NAME),
              Integer.valueOf(webCrawlerProperties.getProperty(PROPERTY_PROXY_HOST_PORT)));
        } else {
          _proxyHost = new HttpHost(webCrawlerProperties.getProperty(PROPERTY_PROXY_HOST_NAME));
        }
      }
      if (webCrawlerProperties.containsKey(PROPERTY_SOCKET_TIMEOUT)) {
        _socketTimeout = Integer.valueOf(webCrawlerProperties.getProperty(PROPERTY_SOCKET_TIMEOUT));
      }
    } catch (final Exception e) {
      _log.warn("Could not read web crawler properties, using default values.", e);
    }
  }

  /**
   * @return the configured Proxy Host or null if no proxy is configured.
   */
  public HttpHost getProxyHost() {
    return _proxyHost;
  }

  /**
   * @return the configured socket timeout (in ms), -1 if no socket timeout has been configured.
   */
  public Integer getSocketTimeout() {
    return _socketTimeout;
  }
}
