/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.sail.rdbms.schema.HashTable;
import org.openrdf.sail.rdbms.schema.ValueType;

public abstract class IdSequence {
    private static final String UTF_8 = "UTF-8";
    private static ThreadLocal<MessageDigest> md5 = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }
    };
    private int LONG = 255;
    private int MOD = 16;
    private HashTable table;

    public int getMod() {
        return this.MOD;
    }

    public abstract int getShift();

    public abstract int getJdbcIdType();

    public abstract String getSqlType();

    public HashTable getHashTable() {
        return this.table;
    }

    public void setHashTable(HashTable table) {
        this.table = table;
    }

    public abstract void init() throws SQLException;

    public abstract Number maxId(ValueType var1);

    public abstract Number minId(ValueType var1);

    public int code(Literal value) {
        return this.shift(this.minId(this.valueOf(value)));
    }

    public long hashOf(Value value) {
        long span = 0xFFFFFFFFFFFFFFFL;
        MessageDigest digest = md5.get();
        long type = this.hashLiteralType(digest, value);
        long hash = type * 31L + this.hash(digest, value.stringValue());
        return hash & 0xFFFFFFFFFFFFFFFL | (long)this.valueOf(value).index() * 0x1000000000000000L;
    }

    public abstract Number nextId(Value var1);

    public boolean isLiteral(Number id) {
        return this.valueOf(id).isLiteral();
    }

    public boolean isLong(Number id) {
        return this.valueOf(id).isLong();
    }

    public boolean isURI(Number id) {
        return this.valueOf(id).isURI();
    }

    public Number idOf(Value value) {
        return this.idOf(this.hashOf(value));
    }

    public abstract Number idOf(Number var1);

    public ValueType valueOf(Number id) {
        int idx = this.shift(id);
        ValueType[] values = ValueType.values();
        if (idx < 0 || idx >= values.length) {
            throw new IllegalArgumentException("Invalid ID " + id);
        }
        return values[idx];
    }

    protected abstract int shift(Number var1);

    protected long hash(MessageDigest digest, String str) {
        try {
            digest.update(str.getBytes(UTF_8));
            return new BigInteger(1, digest.digest()).longValue();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected long hashLiteralType(MessageDigest digest, Value value) {
        if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (lit.getDatatype() != null) {
                return this.hash(digest, lit.getDatatype().stringValue());
            }
            if (lit.getLanguage() != null) {
                return this.hash(digest, lit.getLanguage());
            }
        }
        return 0L;
    }

    private boolean isZoned(Literal lit) {
        String stringValue = lit.stringValue();
        int length = stringValue.length();
        if (length < 1) {
            return false;
        }
        if (stringValue.charAt(length - 1) == 'Z') {
            return true;
        }
        if (length < 6) {
            return false;
        }
        if (stringValue.charAt(length - 3) != ':') {
            return false;
        }
        char chr = stringValue.charAt(length - 6);
        return chr == '+' || chr == '-';
    }

    private ValueType valueOf(BNode value) {
        return ValueType.BNODE;
    }

    protected ValueType valueOf(Literal lit) {
        String lang = lit.getLanguage();
        URI dt = lit.getDatatype();
        int length = lit.stringValue().length();
        if (lang != null) {
            if (length > this.LONG) {
                return ValueType.LANG_LONG;
            }
            return ValueType.LANG;
        }
        if (dt == null) {
            if (length > this.LONG) {
                return ValueType.SIMPLE_LONG;
            }
            return ValueType.SIMPLE;
        }
        if (XMLDatatypeUtil.isNumericDatatype(dt)) {
            return ValueType.NUMERIC;
        }
        if (XMLDatatypeUtil.isCalendarDatatype(dt)) {
            if (this.isZoned(lit)) {
                return ValueType.DATETIME_ZONED;
            }
            return ValueType.DATETIME;
        }
        if (((Object)RDF.XMLLITERAL).equals(dt)) {
            return ValueType.XML;
        }
        if (length > this.LONG) {
            return ValueType.TYPED_LONG;
        }
        return ValueType.TYPED;
    }

    private ValueType valueOf(URI value) {
        if (value.stringValue().length() > this.LONG) {
            return ValueType.URI_LONG;
        }
        return ValueType.URI;
    }

    protected ValueType valueOf(Value value) {
        if (value instanceof URI) {
            return this.valueOf((URI)value);
        }
        if (value instanceof Literal) {
            return this.valueOf((Literal)value);
        }
        assert (value instanceof BNode) : value;
        return this.valueOf((BNode)value);
    }
}

