/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.restapi;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.workermanager.WorkerManager;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class DebugHandler
extends JsonRequestHandler {
    private WorkerManager _workerManager;
    private ClusterConfigService _clusterService;
    private ZooKeeperService _zkService;

    public Object process(String method, String requestUri, Record inputRecord) {
        AnyMap result = FACTORY.createAnyMap();
        if (this._workerManager != null) {
            result.put("workerManager", (Any)this._workerManager.getInfo());
        }
        if (this._zkService != null && this._clusterService != null) {
            result.put("zookeeper", (Any)this.buildZookeeperSection());
        }
        return result;
    }

    private AnyMap buildZookeeperSection() {
        try {
            return this._zkService.getServerState();
        }
        catch (Exception ex) {
            return this.exceptionToAny(new IllegalArgumentException("Error creating zookeeper section", ex));
        }
    }

    public void setWorkerManager(WorkerManager wm) {
        this._workerManager = wm;
    }

    public void unsetWorkerManager(WorkerManager wm) {
        if (this._workerManager == wm) {
            this._workerManager = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService clusterConfigService) {
        this._clusterService = clusterConfigService;
    }

    public void unsetClusterConfigService(ClusterConfigService clusterConfigService) {
        if (this._clusterService == clusterConfigService) {
            this._clusterService = null;
        }
    }

    public void setZooKeeperService(ZooKeeperService zkService) {
        this._zkService = zkService;
    }

    public void unsetZooKeeperService(ZooKeeperService zkService) {
        if (this._zkService == zkService) {
            this._zkService = null;
        }
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    private AnyMap exceptionToAny(Throwable e) {
        try {
            AnyMap error = FACTORY.createAnyMap();
            error.put("error", (Any)this.exceptionToAny(e, new HashSet<String>()));
            return error;
        }
        catch (Exception drecksEx) {
            throw new IllegalArgumentException("Error converting exception \"" + e.toString() + "\"", drecksEx);
        }
    }

    private AnyMap exceptionToAny(Throwable e, Collection<String> visitedLines) throws Exception {
        AnyMap any = FACTORY.createAnyMap();
        any.put("type", e.getClass().getName());
        if (e.getMessage() != null) {
            any.put("message", e.getMessage());
        }
        AnySeq st = FACTORY.createAnySeq();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stElement = stackTraceElementArray[n2];
            String line = stElement.toString();
            st.add(line);
            if (!visitedLines.add(line)) {
                st.add("...");
                break;
            }
            ++n2;
        }
        any.put("at", (Any)st);
        if (e.getCause() != null && e.getCause() != e) {
            any.put("causedBy", (Any)this.exceptionToAny(e.getCause(), visitedLines));
        }
        return any;
    }
}

