/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.InvalidJobException;
import org.eclipse.smila.bulkbuilder.helper.BulkTrackerCallback;
import org.eclipse.smila.bulkbuilder.helper.BulkbuilderTaskProvider;
import org.eclipse.smila.bulkbuilder.helper.MicroBulkbuilder;
import org.eclipse.smila.bulkbuilder.outputs.AppendableBulkOutput;
import org.eclipse.smila.bulkbuilder.outputs.BulkOutput;
import org.eclipse.smila.bulkbuilder.outputs.BulkType;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.WorkflowRunInfo;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.eclipse.smila.taskworker.io.IODataObject;
import org.eclipse.smila.taskworker.output.AppendableOutput;
import org.eclipse.smila.taskworker.output.Output;
import org.eclipse.smila.taskworker.util.Counters;

public abstract class BulkbuilderBase
implements BulkTrackerCallback {
    private static final double MILLISECONDS_PER_SECOND = 1000.0;
    private final ObjectStoreService _objectStore;
    private final BulkbuilderTaskProvider _taskProvider;
    private final MicroBulkbuilder _microBulkbuilder;
    private final Map<String, BulkOutput> _activeInsertBulks = new HashMap<String, BulkOutput>();
    private final Map<String, BulkOutput> _activeDeleteBulks = new HashMap<String, BulkOutput>();
    private final Log _log = LogFactory.getLog(this.getClass());

    public BulkbuilderBase(ObjectStoreService objectStore, BulkbuilderTaskProvider taskProvider, MicroBulkbuilder microBulkbuilder) throws BlackboardAccessException {
        this._objectStore = objectStore;
        this._taskProvider = taskProvider;
        this._microBulkbuilder = microBulkbuilder;
    }

    public synchronized WorkflowRunInfo addRecord(String jobName, Record record) throws BulkbuilderException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"addRecord start");
        }
        try {
            Task task = this._taskProvider.getInitialTask(jobName);
            WorkflowRunInfo workflowRunInfo = this.writeRecordWithRetry(jobName, record, task, BulkType.ADD);
            return workflowRunInfo;
        }
        finally {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"addRecord end");
            }
        }
    }

    public synchronized WorkflowRunInfo deleteRecord(String jobName, Record record) throws BulkbuilderException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"deleteRecord start");
        }
        try {
            Task task = this._taskProvider.getInitialTask(jobName);
            WorkflowRunInfo workflowRunInfo = this.writeRecordWithRetry(jobName, record, task, BulkType.DEL);
            return workflowRunInfo;
        }
        finally {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"deleteRecord end");
            }
        }
    }

    public synchronized WorkflowRunInfo commitBulk(String jobName) throws BulkbuilderException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("commitBulk start for job  '" + jobName + "'"));
        }
        this._taskProvider.checkJobActive(jobName);
        try {
            BulkOutput addBulk = this.getActiveBulk(jobName, BulkType.ADD);
            BulkOutput delBulk = this.getActiveBulk(jobName, BulkType.DEL);
            Map<String, Number> counters = this.getResultCounters(jobName, addBulk, delBulk);
            long startTime = System.nanoTime();
            if (addBulk != null) {
                this.commitBulk(addBulk);
            }
            if (delBulk != null) {
                this.commitBulk(delBulk);
            }
            this.addIoCloseDuration(counters, startTime);
            ResultDescription taskResult = addBulk == null && delBulk == null ? new ResultDescription(TaskCompletionStatus.OBSOLETE, null, null, counters) : new ResultDescription(TaskCompletionStatus.SUCCESSFUL, null, null, counters);
            Task task = this._taskProvider.finishTask(jobName, taskResult);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("commitBulk end for job '" + jobName + "'"));
            }
            return this.createWorkflowRunInfo(task);
        }
        catch (BulkbuilderException e) {
            this._taskProvider.finishTask(jobName, new ResultDescription(TaskCompletionStatus.RECOVERABLE_ERROR, this.getClass().getSimpleName(), e.toString(), null));
            throw e;
        }
    }

    public WorkflowRunInfo addToMicroBulk(String jobName, Record record, String microBulkId) throws BulkbuilderException {
        Task task;
        Map outputBulks;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"addToMicroBulk start");
        }
        if ((outputBulks = (task = this._taskProvider.getInitialTask(jobName)).getOutputBulks()).containsKey("insertedRecords")) {
            this._microBulkbuilder.addToMicroBulk(microBulkId, record);
            return null;
        }
        throw new InvalidJobException("Operation not supported in job '" + jobName + "', slot '" + "insertedRecords" + "' is not connected to a bucket.");
    }

    public synchronized WorkflowRunInfo finishMicroBulk(String jobName, String microBulkId) throws BulkbuilderException {
        try {
            Integer numberOfRecords;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("finishMicroBulk start " + microBulkId));
            }
            if ((numberOfRecords = this._microBulkbuilder.getNumberOfRecords(microBulkId)) <= 0) {
                WorkflowRunInfo workflowRunInfo = this.commitBulk(jobName);
                return workflowRunInfo;
            }
            Task task = this._taskProvider.getInitialTask(jobName);
            byte[] microBulk = this._microBulkbuilder.finishMicroBulk(microBulkId);
            WorkflowRunInfo workflowRunInfo = this.writeMicroBulkWithRetry(jobName, microBulk, numberOfRecords, task);
            return workflowRunInfo;
        }
        finally {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"finishMicroBulk end");
            }
        }
    }

    public void removeMicroBulk(String microBulkId) {
        this._microBulkbuilder.finishMicroBulk(microBulkId);
    }

    @Override
    public synchronized void checkBulks() throws BulkbuilderException {
        BulkOutput currBulk;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"checkBulks start");
        }
        HashSet<String> jobsToCommit = new HashSet<String>();
        for (Map.Entry<String, BulkOutput> curr : this._activeInsertBulks.entrySet()) {
            currBulk = curr.getValue();
            if (!currBulk.isTimedOut()) continue;
            jobsToCommit.add(curr.getKey());
        }
        for (Map.Entry<String, BulkOutput> curr : this._activeDeleteBulks.entrySet()) {
            currBulk = curr.getValue();
            if (!currBulk.isTimedOut()) continue;
            jobsToCommit.add(curr.getKey());
        }
        for (String jobName : jobsToCommit) {
            this.commitBulkQuietly(jobName);
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"checkBulks end");
        }
    }

    public synchronized void shutdown() {
        for (BulkOutput curr : Collections.unmodifiableCollection(this._activeInsertBulks.values())) {
            this.handleShutdownForBulk(curr);
        }
        this._activeInsertBulks.clear();
        for (BulkOutput curr : Collections.unmodifiableCollection(this._activeDeleteBulks.values())) {
            this.handleShutdownForBulk(curr);
        }
        this._activeDeleteBulks.clear();
    }

    protected abstract long getCommitTimeoutMillis(AnyMap var1);

    protected abstract long getBulkSizeLimit(BulkType var1, AnyMap var2);

    protected ObjectStoreService getObjectStore() {
        return this._objectStore;
    }

    protected BulkbuilderTaskProvider getTaskProvider() {
        return this._taskProvider;
    }

    protected MicroBulkbuilder getMicroBulkbuilder() {
        return this._microBulkbuilder;
    }

    protected BulkOutput getActiveBulk(String jobName, BulkType bulkType) {
        if (bulkType == BulkType.DEL) {
            return this._activeDeleteBulks.get(jobName);
        }
        return this._activeInsertBulks.get(jobName);
    }

    protected void setActiveBulk(String jobName, BulkOutput bulkData) {
        BulkType bulkType = bulkData.getBulkType();
        if (bulkType == BulkType.DEL) {
            this._activeDeleteBulks.put(jobName, bulkData);
        } else {
            this._activeInsertBulks.put(jobName, bulkData);
        }
    }

    protected WorkflowRunInfo writeRecordWithRetry(String jobName, Record record, Task task, BulkType bulkType) throws BulkbuilderException {
        try {
            return this.writeRecord(jobName, record, task, bulkType);
        }
        catch (InvalidJobException ex) {
            throw ex;
        }
        catch (BulkbuilderException ex) {
            Task newTask = this.handleErrorOnRecordProcessing(jobName, ex);
            return this.writeRecord(jobName, record, newTask, bulkType);
        }
    }

    private WorkflowRunInfo writeRecord(String jobName, Record record, Task task, BulkType bulkType) throws BulkbuilderException {
        BulkInfo bulkInfo = this.getBulkInfo(jobName, task.getOutputBulks(), bulkType);
        BulkOutput currBulk = this.openBulk(jobName, bulkInfo, bulkType, task.getParameters());
        currBulk.addRecord(record);
        currBulk.setLastModificationTime(System.currentTimeMillis());
        if (currBulk.hasGrownBeyondLimit()) {
            this.commitBulk(jobName);
        }
        return this.createWorkflowRunInfo(task);
    }

    protected WorkflowRunInfo writeMicroBulkWithRetry(String jobName, byte[] microBulk, Integer numberOfRecords, Task task) throws BulkbuilderException {
        try {
            return this.writeMicroBulk(jobName, microBulk, numberOfRecords, task);
        }
        catch (InvalidJobException ex) {
            throw ex;
        }
        catch (BulkbuilderException ex) {
            Task newTask = this.handleErrorOnRecordProcessing(jobName, ex);
            return this.writeMicroBulk(jobName, microBulk, numberOfRecords, newTask);
        }
    }

    private WorkflowRunInfo writeMicroBulk(String jobName, byte[] microBulk, Integer numberOfRecords, Task task) throws BulkbuilderException {
        BulkInfo bulkInfo = this.getBulkInfo(jobName, task.getOutputBulks(), BulkType.ADD);
        BulkOutput currBulk = this.openBulk(jobName, bulkInfo, BulkType.ADD, task.getParameters());
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Writing micro bulk to bulk " + currBulk.getCurrentBulkId() + " for job '" + jobName + "'."));
        }
        ((AppendableBulkOutput)currBulk).addMicroBulk(microBulk, numberOfRecords);
        currBulk.setLastModificationTime(System.currentTimeMillis());
        if (currBulk.hasGrownBeyondLimit()) {
            this.commitBulk(jobName);
        }
        return this.createWorkflowRunInfo(task);
    }

    protected BulkInfo getBulkInfo(String jobName, Map<String, List<BulkInfo>> outputBulks, BulkType bulkType) throws BulkbuilderException {
        List<BulkInfo> slotBulkInfos = null;
        if (bulkType == BulkType.DEL) {
            String slotName = "deletedRecords";
            slotBulkInfos = outputBulks.get(slotName);
            if (slotBulkInfos == null || slotBulkInfos.isEmpty()) {
                throw new InvalidJobException("Operation not supported in job '" + jobName + "', slot '" + "deletedRecords" + "' is not connected to a bucket.");
            }
        } else if (bulkType == BulkType.ADD) {
            String slotName = "insertedRecords";
            slotBulkInfos = outputBulks.get(slotName);
            if (slotBulkInfos == null || slotBulkInfos.isEmpty()) {
                throw new InvalidJobException("Operation not supported in job '" + jobName + "', slot '" + "insertedRecords" + "' is not connected to a bucket.");
            }
        } else {
            throw new InvalidJobException("Bulk type " + (Object)((Object)bulkType) + " not supported in Bulkbuilder.");
        }
        BulkInfo bulkInfo = slotBulkInfos.get(0);
        return bulkInfo;
    }

    private BulkOutput openBulk(String jobName, BulkInfo bulkInfo, BulkType bulkType, AnyMap taskParameters) throws BulkbuilderException {
        BulkOutput activeBulk = this.getActiveBulk(jobName, bulkType);
        if (activeBulk != null) {
            if (bulkInfo.getObjectName().equals(activeBulk.getCurrentBulkId())) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)"openBulk: active bulk found");
                }
                return activeBulk;
            }
            this._log.warn((Object)"Active bulk does not match to given bulk info and has been released, maybe that the respective job has been canceled.");
            this.releaseBulk(activeBulk);
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"openBulk: no active bulk found - creating new bulk");
        }
        activeBulk = this.createBulk(jobName, bulkInfo, bulkType, taskParameters);
        this.setActiveBulk(jobName, activeBulk);
        return activeBulk;
    }

    protected BulkOutput createBulk(String jobName, BulkInfo bulkInfo, BulkType bulkType, AnyMap taskParameters) {
        AppendableBulkOutput bulkData = new AppendableBulkOutput(jobName, bulkInfo.getObjectName(), bulkType);
        bulkData.setBulk((Output)new AppendableOutput(bulkInfo, this._objectStore));
        bulkData.setCommitTimeout(this.getCommitTimeoutMillis(taskParameters));
        bulkData.setBulkSizeLimit(this.getBulkSizeLimit(bulkType, taskParameters));
        return bulkData;
    }

    private void releaseBulk(BulkOutput currBulk) {
        String jobName = currBulk.getJobName();
        if (this._log.isDebugEnabled() && currBulk.getCurrentBulkId() != null) {
            this._log.debug((Object)("Releasing bulk " + currBulk.getCurrentBulkId() + " for job name '" + jobName + "'."));
        }
        currBulk.setBulk(null);
        currBulk.setCurrentBulkId(null);
        switch (currBulk.getBulkType()) {
            case DEL: {
                this._activeDeleteBulks.remove(jobName);
                break;
            }
            case ADD: {
                this._activeInsertBulks.remove(jobName);
                break;
            }
        }
    }

    private void commitBulk(BulkOutput currBulk) throws BulkbuilderException {
        try {
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Committing bulk " + currBulk.getCurrentBulkId() + " for job '" + currBulk.getJobName() + "'"));
                }
                currBulk.commit();
            }
            catch (RuntimeException ex) {
                String message = "Error submitting bulk " + currBulk.getCurrentBulkId();
                throw new BulkbuilderException(message, ex);
            }
        }
        finally {
            this.releaseBulk(currBulk);
        }
    }

    private void commitBulkQuietly(String jobName) {
        try {
            this.commitBulk(jobName);
        }
        catch (BulkbuilderException ex) {
            this._log.warn((Object)("Failed to commit bulks for job '" + jobName + "'"), (Throwable)((Object)ex));
            if (ex.isRecoverable()) {
                this.finishTaskWithError(jobName, TaskCompletionStatus.RECOVERABLE_ERROR, (Exception)((Object)ex));
            }
            this.finishTaskWithError(jobName, TaskCompletionStatus.FATAL_ERROR, (Exception)((Object)ex));
        }
    }

    private Task handleErrorOnRecordProcessing(String jobName, BulkbuilderException ex) throws BulkbuilderException {
        this._log.warn((Object)("Error adding/deleting record for job '" + jobName + "', retrying with new task."), (Throwable)((Object)ex));
        this.commitBulkQuietly(jobName);
        return this._taskProvider.getInitialTask(jobName);
    }

    private void finishTaskWithError(String jobName, TaskCompletionStatus completionStatus, Exception ex) {
        try {
            try {
                this._taskProvider.finishTask(jobName, new ResultDescription(completionStatus, this.getClass().getSimpleName(), ex.toString(), null));
            }
            catch (Exception e2) {
                this._log.warn((Object)"Error during clean up.", (Throwable)e2);
                this._activeInsertBulks.remove(jobName);
                this._activeDeleteBulks.remove(jobName);
            }
        }
        finally {
            this._activeInsertBulks.remove(jobName);
            this._activeDeleteBulks.remove(jobName);
        }
    }

    private WorkflowRunInfo createWorkflowRunInfo(Task task) {
        if (task != null) {
            Map taskProperties = task.getProperties();
            return new WorkflowRunInfo((String)taskProperties.get("jobName"), (String)taskProperties.get("jobRunId"), (String)taskProperties.get("workflowRunId"));
        }
        return null;
    }

    protected Map<String, Number> getResultCounters(String jobName, BulkOutput ... bulkDatas) {
        HashMap<String, Number> counters = new HashMap<String, Number>();
        BulkOutput[] bulkOutputArray = bulkDatas;
        int n = bulkDatas.length;
        int n2 = 0;
        while (n2 < n) {
            BulkOutput bulk = bulkOutputArray[n2];
            if (bulk != null) {
                String prefix = null;
                if (bulk.getBulkType() == BulkType.ADD) {
                    prefix = "insertedRecords";
                } else if (bulk.getBulkType() == BulkType.DEL) {
                    prefix = "deletedRecords";
                }
                this.addResultCounters(counters, bulk, prefix);
            }
            ++n2;
        }
        return counters;
    }

    protected void addResultCounters(Map<String, Number> counters, BulkOutput bulk, String slotName) {
        String prefix = "output." + slotName;
        if (bulk != null) {
            long durationPerform;
            IODataObject io = bulk.getOutput();
            long durationOpen = io.getDurationOpen();
            if (durationOpen > 0L) {
                Counters.addDuration(counters, (String)"duration.iodata.open", (long)durationOpen);
            }
            if ((durationPerform = io.getDurationPerform()) > 0L) {
                Counters.addDuration(counters, (String)"duration.perform.output", (long)durationPerform);
                Counters.addDuration(counters, (String)("duration.perform.output." + slotName), (long)durationPerform);
            }
            Counters.addAll(counters, (Map)io.getCounter(), (String)prefix);
            counters.put(String.valueOf(prefix) + ".duration", (double)(System.currentTimeMillis() - bulk.getBulkStartTime()) / 1000.0);
        }
    }

    private void addIoCloseDuration(Map<String, Number> counters, long startTime) {
        Counters.addDuration(counters, (String)"duration.iodata.close", (long)(System.nanoTime() - startTime));
        if (counters.containsKey("duration.iodata.close")) {
            Counters.add(counters, (String)"duration.iodata", (double)counters.get("duration.iodata.close").doubleValue());
        }
        if (counters.containsKey("duration.iodata.open")) {
            Counters.add(counters, (String)"duration.iodata", (double)counters.get("duration.iodata.open").doubleValue());
        }
    }

    private void handleShutdownForBulk(BulkOutput currBulk) {
        if (currBulk.getBulk() != null) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("Deactivating service while bulk " + currBulk.getCurrentBulkId() + " is still open. Closing it without creating a task."));
            }
            try {
                currBulk.commit();
            }
            catch (Exception ex) {
                this._log.debug((Object)"Error committing bulk on shutdown", (Throwable)ex);
            }
        }
        this.releaseBulk(currBulk);
    }
}

