/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class BucketHandler
extends AJobManagerHandler {
    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String bucketName = this.getBucketName(requestUri);
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        if (this.isGetRequest(method)) {
            BucketDefinition bucket;
            boolean returnDetails = false;
            if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
                returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
            }
            if ((bucket = defPersistence.getBucket(bucketName)) == null) {
                throw new ConfigNotFoundException("Bucket '" + bucketName + "' not found.");
            }
            return bucket.toAny(returnDetails);
        }
        if (this.isDeleteRequest(method)) {
            defPersistence.removeBucket(bucketName);
        }
        return null;
    }

    private String getBucketName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetOrDeleteRequest(method);
    }
}

