/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementRegistration;
import org.eclipse.smila.ontology.SesameOntologyManager;
import org.eclipse.smila.ontology.config.HttpStore;
import org.eclipse.smila.ontology.config.RepositoryConfig;
import org.eclipse.smila.ontology.config.SesameConfiguration;
import org.eclipse.smila.ontology.config.Stackable;
import org.eclipse.smila.ontology.internal.SesameConfigurationHandler;
import org.eclipse.smila.ontology.internal.SesameOntologyAgent;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.osgi.service.component.ComponentContext;

public class SesameOntologyManagerImpl
implements SesameOntologyManager {
    public static final String CONFIG_NAME = "sesameConfig.xml";
    private final Log _log = LogFactory.getLog(this.getClass());
    private SesameConfiguration _configuration;
    private SesameOntologyAgent _agent;
    private ManagementAgentLocation _agentLocation;
    private final Map<String, Repository> _repositories = new HashMap<String, Repository>();

    public SesameOntologyManagerImpl() {
        this._log.trace((Object)"instance created");
    }

    @Override
    public synchronized RepositoryConnection getConnection(String name) throws RepositoryException {
        Repository repository = this._repositories.get(name);
        if (repository == null) {
            RepositoryConfig config = this.findRepositoryConfig(name);
            repository = this.openRepository(config);
            this._repositories.put(name, repository);
        }
        return repository.getConnection();
    }

    @Override
    public RepositoryConnection getDefaultConnection() throws RepositoryException {
        if (this._configuration == null) {
            throw new RepositoryException("SesameOntologyManager does not have a configuration, restart service to initialize.");
        }
        return this.getConnection(this._configuration.getDefault());
    }

    @Override
    public List<String> getRepositoryNames() {
        List<RepositoryConfig> configs;
        ArrayList<String> result = new ArrayList<String>();
        if (this._configuration != null && (configs = this._configuration.getRepositoryConfig()) != null) {
            for (RepositoryConfig config : configs) {
                result.add(config.getName());
            }
        }
        return result;
    }

    protected void activate(ComponentContext context) {
        block10: {
            this._log.trace((Object)"activating");
            try {
                InputStream configStream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.ontology", (String)CONFIG_NAME);
                if (configStream != null) {
                    try {
                        try {
                            Unmarshaller parser = SesameConfigurationHandler.createConfigurationUnmarshaller(true);
                            this._configuration = (SesameConfiguration)parser.unmarshal(configStream);
                            this._agent = new SesameOntologyAgent(this);
                            this._agentLocation = ManagementRegistration.INSTANCE.getCategory("Ontology").getLocation("Sesame");
                            ManagementRegistration.INSTANCE.registerAgent(this._agentLocation, (ManagementAgent)this._agent);
                        }
                        catch (JAXBException ex) {
                            this._log.error((Object)"error reading sesameConfig.xml", (Throwable)ex);
                            IOUtils.closeQuietly((InputStream)configStream);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((InputStream)configStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)configStream);
                    break block10;
                }
                this._log.error((Object)"could not find configuration file sesameConfig.xml");
            }
            catch (Exception exception) {
                this._log.error((Object)"could not find configuration file sesameConfig.xml");
            }
        }
        if (this._configuration == null) {
            this._log.info((Object)"no configuration read, service is inactive. restart bundle to retry.");
        } else {
            this._log.info((Object)"active!");
        }
    }

    protected void deactivate(ComponentContext context) {
        this._log.trace((Object)"deactivating");
        ManagementRegistration.INSTANCE.unregisterAgent(this._agentLocation);
        this._agent = null;
        for (String repoName : this._repositories.keySet()) {
            try {
                this._log.debug((Object)("shutting down repository " + repoName));
                this._repositories.get(repoName).shutDown();
            }
            catch (Exception ex) {
                this._log.error((Object)("error during shutdown of repository " + repoName), (Throwable)ex);
            }
        }
        this._repositories.clear();
        this._log.info((Object)"deactivated!");
    }

    private RepositoryConfig findRepositoryConfig(String name) throws RepositoryException {
        if (this._configuration == null) {
            throw new RepositoryException("SesameOntologyManager does not have a configuration, restart service to initialize.");
        }
        for (RepositoryConfig config : this._configuration.getRepositoryConfig()) {
            if (!name.equals(config.getName())) continue;
            return config;
        }
        throw new RepositoryException("Unknown repository configuration '" + name + "'.");
    }

    private Repository openRepository(RepositoryConfig config) throws RepositoryException {
        try {
            File dataDir = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.ontology", (String)config.getName());
            Repository repository = null;
            if (config.getHttpStore() != null) {
                repository = this.openHttpRepository(config.getHttpStore(), dataDir);
            } else {
                Sail sail = null;
                if (config.getMemoryStore() != null) {
                    sail = this.openMemoryStore(config.getMemoryStore(), dataDir);
                } else if (config.getNativeStore() != null) {
                    sail = this.openNativeStore(config.getNativeStore(), dataDir);
                } else if (config.getRdbmsStore() != null) {
                    sail = this.openRdbmsStore(config.getRdbmsStore(), dataDir);
                }
                if (config.getStackable() != null) {
                    for (Stackable stackable : config.getStackable()) {
                        try {
                            StackableSail stackSail = (StackableSail)Class.forName(stackable.getClassname()).newInstance();
                            stackSail.setBaseSail(sail);
                            sail = stackSail;
                        }
                        catch (Exception ex) {
                            throw new RepositoryException("Stackable of class " + stackable.getClassname() + " could not be created.", (Throwable)ex);
                        }
                    }
                }
                if (sail != null) {
                    repository = new SailRepository(sail);
                    repository.initialize();
                }
            }
            return repository;
        }
        catch (IOException ex) {
            throw new RepositoryException("Could not create repository workspace directory " + config.getName(), (Throwable)ex);
        }
    }

    private Sail openNativeStore(org.eclipse.smila.ontology.config.NativeStore config, File dataDir) {
        NativeStore natStore = new NativeStore(dataDir);
        natStore.setTripleIndexes(config.getIndexes());
        natStore.setForceSync(config.isForceSync());
        return natStore;
    }

    private Sail openMemoryStore(org.eclipse.smila.ontology.config.MemoryStore config, File dataDir) {
        MemoryStore memStore = new MemoryStore(dataDir);
        memStore.setPersist(config.isPersist());
        memStore.setSyncDelay((long)config.getSyncDelay());
        return memStore;
    }

    private Sail openRdbmsStore(org.eclipse.smila.ontology.config.RdbmsStore config, File dataDir) throws RepositoryException {
        try {
            RdbmsStore dbStore = config.getUser() != null && config.getPassword() != null ? new RdbmsStore(config.getDriver(), config.getUrl(), config.getUser(), config.getPassword()) : new RdbmsStore(config.getDriver(), config.getUrl());
            dbStore.setDataDir(dataDir);
            dbStore.setMaxNumberOfTripleTables(config.getMaxTripleTables());
            dbStore.setIndexed(config.isIndexed());
            dbStore.setSequenced(config.isSequenced());
            return dbStore;
        }
        catch (SailException ex) {
            throw new RepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Repository openHttpRepository(HttpStore config, File dataDir) {
        HTTPRepository httpRepository = new HTTPRepository(config.getUrl(), config.getRepositoryId());
        httpRepository.setDataDir(dataDir);
        if (config.getUser() != null && config.getPassword() != null) {
            httpRepository.setUsernameAndPassword(config.getUser(), config.getPassword());
        }
        HTTPRepository repository = httpRepository;
        return repository;
    }
}

