/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.VisitedLinksService;
import org.eclipse.smila.importing.compounds.CompoundExtractor;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;
import org.eclipse.smila.importing.crawler.file.FileCrawlingContext;
import org.eclipse.smila.importing.util.RecordOutputHandler;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.TaskLog;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;

public class FileCrawlerWorker
implements Worker {
    public static final String NAME = "fileCrawler";
    public static final String INPUT_SLOT_DIRS_TO_CRAWL = "directoriesToCrawl";
    public static final String OUTPUT_SLOT_DIRS_TO_CRAWL = "directoriesToCrawl";
    public static final String OUTPUT_SLOT_CRAWLED_RECORDS = "crawledRecords";
    public static final String TASK_PARAM_ROOT_FOLDER = "rootFolder";
    public static final String TASK_PARAM_MAX_FILES_PER_BULK = "maxFilesPerBulk";
    public static final String TASK_PARAM_MIN_FILES_PER_BULK = "minFilesPerBulk";
    public static final String TASK_PARAM_DIRS_PER_BULK = "directoriesPerBulk";
    public static final Long MAX_FILES_PER_BULK_DEFAULT = 1000L;
    public static final Long MIN_FILES_PER_BULK_DEFAULT = 0L;
    public static final Long DIRS_PER_BULK_DEFAULT = 1L;
    private static final String BULK_ID_FOR_INITIAL_TASK = "initial";
    private final Log _log = LogFactory.getLog(this.getClass());
    private FileCrawlerService _fileCrawler;
    private VisitedLinksService _visitedLinks;
    private CompoundExtractor _compoundExtractor;

    public String getName() {
        return NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        try {
            FileCrawlingContext crawlContext = new FileCrawlingContext(taskContext);
            RecordOutputHandler fileBulks = new RecordOutputHandler(taskContext.getOutputs(), crawlContext.getMaxFilesPerBulk(), OUTPUT_SLOT_CRAWLED_RECORDS);
            Inputs inputs = taskContext.getInputs();
            if (inputs.getDataObjectCount("directoriesToCrawl") == 0) {
                this.crawlRootFolder(crawlContext, fileBulks);
            } else {
                this.crawlInputFolders(crawlContext, fileBulks);
            }
        }
        catch (Exception e) {
            this._log.error((Object)e);
            throw e;
        }
    }

    private void crawlRootFolder(FileCrawlingContext crawlContext, RecordOutputHandler fileBulks) throws Exception {
        this._visitedLinks.clearSource(crawlContext.getDataSource());
        RecordOutputHandler directoryBulks = new RecordOutputHandler(crawlContext.getTaskContext().getOutputs(), 1L, "directoriesToCrawl");
        this.crawl(crawlContext.getRootFolder(), crawlContext, fileBulks, directoryBulks, BULK_ID_FOR_INITIAL_TASK, 0L);
    }

    private void crawlInputFolders(FileCrawlingContext crawlContext, RecordOutputHandler fileBulks) throws ObjectStoreException, IOException {
        RecordOutputHandler directoryBulks = new RecordOutputHandler(crawlContext.getTaskContext().getOutputs(), crawlContext.getDirectoriesPerBulk(), "directoriesToCrawl");
        RecordInput directoryInput = crawlContext.getTaskContext().getInputs().getAsRecordInput("directoriesToCrawl");
        Record record = directoryInput.getRecord();
        while (record != null && !crawlContext.getTaskContext().isCanceled()) {
            String dirName = record.getMetadata().getStringValue("fileFolder");
            TaskLog taskLog = crawlContext.getTaskContext().getLog();
            try {
                if (dirName == null || dirName.trim().isEmpty()) {
                    taskLog.error("Failed to crawl directory. Attribute 'fileFolder' of record " + record.getId() + " is null or empty");
                } else {
                    this.crawl(dirName, crawlContext, fileBulks, directoryBulks, directoryInput.getObjectName(), crawlContext.getMinFilesPerBulk());
                }
            }
            catch (Exception e) {
                taskLog.error("Failed to crawl directory '" + dirName + "' of record " + record.getId(), (Throwable)e);
            }
            record = directoryInput.getRecord();
        }
    }

    private void crawl(String dirName, FileCrawlingContext crawlContext, RecordOutputHandler fileBulks, RecordOutputHandler directoryBulks, String inputBulkId, long minFilesPerBulk) throws Exception {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("fileFolder '" + dirName + "' is not a directory");
        }
        if (this.checkAndMarkVisited(dir, crawlContext, inputBulkId)) {
            this._log.info((Object)("Not crawling into directory " + dir + ", because it has been visited before."));
            return;
        }
        Collection<File> subDirectories = this.createFileOutputBulks(dir, crawlContext, fileBulks);
        if ((long)fileBulks.getFileCount() < minFilesPerBulk) {
            Iterator<File> it = subDirectories.iterator();
            while (it.hasNext() && (long)fileBulks.getFileCount() < minFilesPerBulk) {
                File subDir = it.next();
                Collection<File> subDirDirectories = this.createFileOutputBulks(subDir, crawlContext, fileBulks);
                this.createDirectoryOutputBulks(crawlContext.getDataSource(), subDirDirectories, directoryBulks);
                it.remove();
            }
        }
        this.createDirectoryOutputBulks(crawlContext.getDataSource(), subDirectories, directoryBulks);
    }

    private Collection<File> createFileOutputBulks(File dir, FileCrawlingContext crawlContext, RecordOutputHandler fileBulks) throws Exception {
        ArrayList<File> subDirectories = new ArrayList<File>();
        Collection<File> filesAndFolders = this._fileCrawler.list(dir);
        int fileCount = 0;
        for (File file : filesAndFolders) {
            if (file.isFile() && crawlContext.getFilterEvaluator().applyFiltersForCrawledFile(dir, file)) {
                Record fileRecord = this._fileCrawler.fileToRecord(file, crawlContext.getDataSource(), false);
                if (this.isCompoundRecord(fileRecord)) {
                    this.setIsCompound(fileRecord);
                }
                crawlContext.getMapper().mapNames(fileRecord, this._fileCrawler.getFilePropertyNames());
                fileBulks.writeRecord(fileRecord);
                ++fileCount;
                continue;
            }
            if (file.isDirectory() && crawlContext.getFilterEvaluator().applyFiltersForCrawledFolder(file, crawlContext.getRootFolder())) {
                subDirectories.add(file);
                continue;
            }
            this._log.warn((Object)("directory " + dir.getAbsolutePath() + " contains object " + file.getName() + " which is neither a file nor a directory."));
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("directory " + dir.getAbsolutePath() + " contained " + fileCount + " files and " + subDirectories.size() + " directories."));
        }
        return subDirectories;
    }

    private void createDirectoryOutputBulks(String dataSource, Collection<File> subDirectories, RecordOutputHandler directoryBulks) throws IOException, ObjectStoreException {
        for (File subDir : subDirectories) {
            Record directoryRecord = this._fileCrawler.dirToRecord(subDir, dataSource);
            directoryBulks.writeRecord(directoryRecord);
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)("added bulk for directory " + subDir.getAbsolutePath()));
        }
    }

    private boolean checkAndMarkVisited(File directory, FileCrawlingContext context, String inputBulkId) throws ImportingException {
        if (context.getFilterConfig() != null && context.getFilterConfig().followSymbolicLinks()) {
            try {
                String canonicalPath = this.getCanonicalPath(directory);
                return this._visitedLinks.checkAndMarkVisited(context.getDataSource(), canonicalPath, context.getJobRunId(), inputBulkId);
            }
            catch (IOException ex) {
                throw new ImportingException("Error checking " + directory + " for symbolic-link cycles", (Throwable)ex);
            }
        }
        return false;
    }

    private String getCanonicalPath(File file) throws IOException {
        File fileInCanonicalDir;
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return fileInCanonicalDir.getCanonicalPath();
    }

    private boolean isCompoundRecord(Record record) {
        return this._compoundExtractor.canExtract(record.getMetadata().getStringValue("fileName"), null);
    }

    private void setIsCompound(Record record) {
        record.getMetadata().put("_isCompound", Boolean.valueOf(true));
    }

    public void setFileCrawlerService(FileCrawlerService fileCrawler) {
        this._fileCrawler = fileCrawler;
    }

    public void unsetFileCrawlerService(FileCrawlerService fileCrawler) {
        if (this._fileCrawler == fileCrawler) {
            this._fileCrawler = null;
        }
    }

    public void setCompoundExtractor(CompoundExtractor compoundExtractor) {
        this._compoundExtractor = compoundExtractor;
    }

    public void unsetCompoundExtractor(CompoundExtractor compoundExtractor) {
        if (this._compoundExtractor == compoundExtractor) {
            this._compoundExtractor = null;
        }
    }

    public void setVisitedLinks(VisitedLinksService visitedLinks) {
        this._visitedLinks = visitedLinks;
    }

    public void unsetVisitedLinks(VisitedLinksService visitedLinks) {
        if (this._visitedLinks == visitedLinks) {
            this._visitedLinks = null;
        }
    }
}

