/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.admin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.solr.admin.AbstractSolrAdministration;
import org.eclipse.smila.solr.admin.SolrAdministrationException;
import org.eclipse.smila.solr.server.SolrServers;

public class EmbeddedSolrAdministration
extends AbstractSolrAdministration {
    private final CoreAdminHandler _adminHandler;

    public EmbeddedSolrAdministration(SolrServers servers, CoreContainer coreContainer) {
        super(servers);
        this._adminHandler = new CoreAdminHandler(coreContainer);
    }

    @Override
    NamedList<Object> handleRequest(Map<String, String[]> parameter) throws SolrAdministrationException {
        try {
            Object[] coreName = parameter.get("core");
            if (ArrayUtils.isEmpty((Object[])coreName)) {
                throw new MissingParameterException("EmbeddedSolrAdministration supports status only with a core specified.");
            }
            SolrCore core = this._adminHandler.getCoreContainer().getCore((String)coreName[0]);
            if (core == null) {
                String msg = MessageFormat.format("There is no core with name '{0}' registred in core container.", coreName[0]);
                throw new IllegalArgumentException(msg);
            }
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, parameter);
            SolrQueryResponse rsp = new SolrQueryResponse();
            this._adminHandler.handleRequest((SolrQueryRequest)req, rsp);
            return rsp.getValues();
        }
        catch (Exception exception) {
            String debugParameter = this.convertMapToString(parameter);
            throw new SolrAdministrationException("Error while handle request on embedded server with following params: " + debugParameter, exception);
        }
    }

    @Override
    public List<String> getCoreNames() throws Exception {
        return new ArrayList<String>(this._adminHandler.getCoreContainer().getCoreNames());
    }

    @Override
    public List<String> readFieldNames(String coreName) throws Exception {
        SolrCore core = this._adminHandler.getCoreContainer().getCore(coreName);
        if (core == null) {
            throw new SolrServerException("No configuration found in solr.home '" + this._adminHandler.getCoreContainer().getSolrHome() + "' for core with name: " + coreName);
        }
        return new ArrayList<String>(core.getSchema().getFields().keySet());
    }
}

