/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.solr.search.SolrResultAccessor;

public class SolrQueryBuilder
extends QueryBuilder {
    private static final String DEFAULT_WORKFLOW = "SolrSearchDefaultWorkflow";
    private static final String DEFAULT_RECORD_ID = "SolrSearchRecordId: ";

    public SolrQueryBuilder() {
        super(DEFAULT_WORKFLOW);
        String id = DEFAULT_RECORD_ID + UUID.randomUUID();
        this.setId(id);
    }

    public SolrQueryBuilder(String workflowName) {
        super(workflowName);
    }

    public SolrQueryBuilder(String workflowName, DataFactory factory) {
        super(workflowName, factory);
    }

    public SolrQueryBuilder(String workflowName, Record request) {
        super(workflowName, request);
    }

    public SolrQueryBuilder setStart(int start) {
        this.setOffset(start);
        return this;
    }

    public SolrQueryBuilder setRows(int rows) {
        this.setMaxCount(rows);
        return this;
    }

    public SolrQueryBuilder addFields(String ... fields) {
        this.addResultAttributes(fields);
        return this;
    }

    public SolrQueryBuilder setRequestHandler(String name) {
        if (StringUtils.isBlank((String)name)) {
            this.getSolrQueryMap().remove((Object)"qt");
        } else {
            this.getSolrQueryMap().put("qt", name);
        }
        return this;
    }

    public SolrQueryBuilder addFilterQuery(String filterQuery) {
        if (filterQuery != null) {
            this.getSolrQueryMap().getSeq("fq", true).add(filterQuery);
        }
        return this;
    }

    AnyMap getSolrQueryMap() {
        return this.getMetadata().getMap("_solr.query", true);
    }

    public SolrResultAccessor executeRequest(SearchService searchService) throws ProcessingException {
        super.executeRequest(searchService);
        return new SolrResultAccessor(this.getWorkflowName(), this.getQuery());
    }

    public SolrQueryBuilder setQueryFindAll() {
        this.setQuery("*:*");
        return this;
    }

    public SolrQueryBuilder setShards(String ... shards) {
        String[] stringArray = shards;
        int n = shards.length;
        int n2 = 0;
        while (n2 < n) {
            String shard = stringArray[n2];
            this.getSolrQueryMap().getSeq("shards", true).add(shard);
            ++n2;
        }
        return this;
    }

    public void setMoreLikeThis(AnyMap mltArgs) {
        this.getSolrQueryMap().put("moreLikeThis", (Any)mltArgs);
        Value value = mltArgs.getValue("mlt");
        if (value == null) {
            mltArgs.put("mlt", Boolean.valueOf(true));
        }
    }

    public void addNativeParam(String parameterName, Object parameterValue) {
        AnyMap map = this.getSolrQueryMap().getMap("nativeParameters", true);
        map.add(parameterName, (Any)this.getFactory().autoConvertValue(parameterValue));
    }

    public void setNativeParam(String parameterName, Object parameterValue) {
        AnyMap map = this.getSolrQueryMap().getMap("nativeParameters", true);
        map.put(parameterName, (Any)this.getFactory().autoConvertValue(parameterValue));
    }

    public AnyMap addFilterGroup(String filterGroupName) {
        return this.getSolrQueryMap().getMap("filterGroups", true).getMap(filterGroupName, true);
    }

    public AnyMap addFilterGroupLocalParam(String filterGroupName, Object ... params) {
        AnyMap localParams = this.addFilterGroup(filterGroupName).getMap("localParams", true);
        if (params != null) {
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                AnyUtil.objectToAny((Object)param);
                ++n2;
            }
        }
        return localParams;
    }
}

