/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateRequest
extends AbstractUpdateRequest {
    private List<SolrInputDocument> documents = null;
    private Iterator<SolrInputDocument> docIterator = null;
    private List<String> deleteById = null;
    private List<String> deleteQuery = null;

    public UpdateRequest() {
        super(SolrRequest.METHOD.POST, "/update");
    }

    public UpdateRequest(String url) {
        super(SolrRequest.METHOD.POST, url);
    }

    public void clear() {
        if (this.documents != null) {
            this.documents.clear();
        }
        if (this.deleteById != null) {
            this.deleteById.clear();
        }
        if (this.deleteQuery != null) {
            this.deleteQuery.clear();
        }
    }

    public UpdateRequest add(SolrInputDocument doc) {
        if (this.documents == null) {
            this.documents = new ArrayList<SolrInputDocument>(2);
        }
        this.documents.add(doc);
        return this;
    }

    public UpdateRequest add(Collection<SolrInputDocument> docs) {
        if (this.documents == null) {
            this.documents = new ArrayList<SolrInputDocument>(docs.size() + 1);
        }
        this.documents.addAll(docs);
        return this;
    }

    public UpdateRequest deleteById(String id) {
        if (this.deleteById == null) {
            this.deleteById = new ArrayList<String>();
        }
        this.deleteById.add(id);
        return this;
    }

    public UpdateRequest deleteById(List<String> ids) {
        if (this.deleteById == null) {
            this.deleteById = new ArrayList<String>(ids);
        } else {
            this.deleteById.addAll(ids);
        }
        return this;
    }

    public UpdateRequest deleteByQuery(String q) {
        if (this.deleteQuery == null) {
            this.deleteQuery = new ArrayList<String>();
        }
        this.deleteQuery.add(q);
        return this;
    }

    @Deprecated
    public UpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher) {
        return this.setAction(action, waitFlush, waitSearcher, 1);
    }

    @Deprecated
    public UpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        if (action == ACTION.OPTIMIZE) {
            this.params.set("optimize", "true");
            this.params.set("maxSegments", maxSegments);
        } else if (action == ACTION.COMMIT) {
            this.params.set("commit", "true");
        }
        this.params.set("waitFlush", waitFlush + "");
        this.params.set("waitSearcher", waitSearcher + "");
        return this;
    }

    @Deprecated
    public UpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments, boolean expungeDeletes) {
        this.setAction(action, waitFlush, waitSearcher, maxSegments);
        this.params.set("expungeDeletes", "" + expungeDeletes);
        return this;
    }

    public void setDocIterator(Iterator<SolrInputDocument> docIterator) {
        this.docIterator = docIterator;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return ClientUtils.toContentStreams(this.getXML(), "application/xml; charset=UTF-8");
    }

    public String getXML() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXML(writer);
        writer.flush();
        String xml = writer.toString();
        return xml.length() > 0 ? xml : null;
    }

    public void writeXML(Writer writer) throws IOException {
        boolean deleteQ;
        if (this.documents != null && this.documents.size() > 0 || this.docIterator != null) {
            if (this.commitWithin > 0) {
                writer.write("<add commitWithin=\"" + this.commitWithin + "\">");
            } else {
                writer.write("<add>");
            }
            if (this.documents != null) {
                for (SolrInputDocument doc : this.documents) {
                    if (doc == null) continue;
                    ClientUtils.writeXML(doc, writer);
                }
            }
            if (this.docIterator != null) {
                while (this.docIterator.hasNext()) {
                    SolrInputDocument doc = this.docIterator.next();
                    if (doc == null) continue;
                    ClientUtils.writeXML(doc, writer);
                }
            }
            writer.write("</add>");
        }
        boolean deleteI = this.deleteById != null && this.deleteById.size() > 0;
        boolean bl = deleteQ = this.deleteQuery != null && this.deleteQuery.size() > 0;
        if (deleteI || deleteQ) {
            writer.append("<delete>");
            if (deleteI) {
                for (String id : this.deleteById) {
                    writer.append("<id>");
                    XML.escapeCharData(id, writer);
                    writer.append("</id>");
                }
            }
            if (deleteQ) {
                for (String q : this.deleteQuery) {
                    writer.append("<query>");
                    XML.escapeCharData(q, writer);
                    writer.append("</query>");
                }
            }
            writer.append("</delete>");
        }
    }

    public List<SolrInputDocument> getDocuments() {
        return this.documents;
    }

    public Iterator<SolrInputDocument> getDocIterator() {
        return this.docIterator;
    }

    public List<String> getDeleteById() {
        return this.deleteById;
    }

    public List<String> getDeleteQuery() {
        return this.deleteQuery;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum ACTION {
        COMMIT,
        OPTIMIZE;

    }
}

