/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1.xpath10.jaxp;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.WrappedResolverException;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.v1.CompilerContext;
import org.apache.ode.bpel.compiler.v1.xpath10.XslCompileUriResolver;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final Log __log = LogFactory.getLog(JaxpFunctionResolver.class);
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10Expression _out;
    private NSContext _nsContext;
    private String _bpelNS;

    public JaxpFunctionResolver(CompilerContext compilerContext, OXPath10Expression oXPath10Expression, NSContext nSContext, String string) {
        this._cctx = compilerContext;
        this._bpelNS = string;
        this._nsContext = nSContext;
        this._bpelNS = string;
        this._out = oXPath10Expression;
    }

    public XPathFunction resolveFunction(QName qName, int n) {
        __log.debug((Object)("JAXP compiler: Resolving function " + qName));
        if (qName.getNamespaceURI() == null) {
            throw new WrappedResolverException("Undeclared namespace for " + qName);
        }
        if (qName.getNamespaceURI().equals(this._bpelNS)) {
            String string = qName.getLocalPart();
            if ("getVariableData".equals(string)) {
                return new GetVariableData();
            }
            if ("getVariableProperty".equals(string)) {
                return new GetVariableProperty();
            }
            if ("getLinkStatus".equals(string)) {
                return new GetLinkStatus();
            }
            if ("doXslTransform".equals(string)) {
                return new DoXslTransform();
            }
            throw new WrappedResolverException(__msgs.errUnknownBpelFunction(string));
        }
        return null;
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() < 2 || list.size() % 2 != 0) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("doXslTransform"));
            }
            String string = (String)list.get(0);
            OXslSheet oXslSheet = JaxpFunctionResolver.this._cctx.compileXslt(string);
            try {
                XslTransformHandler.getInstance().parseXSLSheet(JaxpFunctionResolver.this._cctx.getBaseResourceURI(), oXslSheet.uri, oXslSheet.sheetBody, (URIResolver)new XslCompileUriResolver(JaxpFunctionResolver.this._cctx, JaxpFunctionResolver.this._out));
            }
            catch (Exception exception) {
                throw new CompilationException(__msgs.errXslCompilation(string, exception.toString()));
            }
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.xslSheets.put(oXslSheet.uri, oXslSheet);
            return "";
        }
    }

    public class GetLinkStatus
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getLinkStatus"));
            }
            String string = (String)list.get(0);
            OLink oLink = JaxpFunctionResolver.this._cctx.resolveLink(string);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.links.put(string, oLink);
            return "";
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableProperty"));
            }
            String string = (String)list.get(0);
            OScope.Variable variable = JaxpFunctionResolver.this._cctx.resolveVariable(string);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(string, variable);
            String string2 = (String)list.get(1);
            QName qName = JaxpFunctionResolver.this._nsContext.derefQName(string2);
            if (qName == null) {
                throw new CompilationException(__msgs.errInvalidQName(string2));
            }
            OProcess.OProperty oProperty = JaxpFunctionResolver.this._cctx.resolveProperty(qName);
            JaxpFunctionResolver.this._cctx.resolvePropertyAlias(variable, qName);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.properties.put(string2, oProperty);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(string, variable);
            return "";
        }
    }

    public class GetVariableData
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() < 1 || list.size() > 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableData"));
            }
            String string = (String)list.get(0);
            String string2 = list.size() > 1 ? (String)list.get(1) : null;
            String string3 = list.size() > 2 ? (String)list.get(2) : null;
            OScope.Variable variable = JaxpFunctionResolver.this._cctx.resolveVariable(string);
            OMessageVarType.Part part = string2 != null ? JaxpFunctionResolver.this._cctx.resolvePart(variable, string2) : null;
            OExpression oExpression = null;
            if (string3 != null) {
                oExpression = JaxpFunctionResolver.this._cctx.compileExpr(string3, JaxpFunctionResolver.this._nsContext);
            }
            JaxpFunctionResolver.this._out.addGetVariableDataSig(string, string2, string3, new OXPath10Expression.OSigGetVariableData(JaxpFunctionResolver.this._cctx.getOProcess(), variable, part, oExpression));
            return "";
        }
    }
}

