/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.worker;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.DeltaImportStrategy;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.importing.State;
import org.eclipse.smila.importing.worker.WorkerUsingDeltaService;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class UpdatePusherWorker
extends WorkerUsingDeltaService {
    public static final String DELETE_SHARD_PARAM = "deleteRecordsShard";
    private static final String WORKER_NAME = "updatePusher";
    private static final String INPUT_SLOT_NAME = "recordsToPush";
    private static final String OUTPUT_SLOT_NAME = "pushedRecords";
    private static final String JOB_TO_PUSH_TO_PARAM = "jobToPushTo";
    private BulkbuilderService _bulkbuilder;
    private final Log _log = LogFactory.getLog(this.getClass());

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        String targetJobName = this.getRequiredParameter(taskContext, JOB_TO_PUSH_TO_PARAM);
        String jobRunId = this.getJobRunId(taskContext);
        DeltaImportStrategy deltaUsage = this.getDeltaImportStrategy(taskContext);
        if (taskContext.getTask().getProperties().containsKey("isCompletingTask")) {
            if (deltaUsage.isDeltaDeleteEnabled()) {
                this.deleteObsoleteRecords(taskContext, targetJobName, jobRunId);
            } else {
                taskContext.getLog().warn("Got a completion task for a job that has delta-delete disabled. Ignoring this task.");
            }
        } else {
            this.pushUpdatedRecords(taskContext, targetJobName, jobRunId, deltaUsage);
        }
    }

    private void deleteObsoleteRecords(TaskContext taskContext, String targetJobName, String jobRunId) throws DeltaException, BulkbuilderException {
        String sourceId = this.getRequiredParameter(taskContext, "dataSource");
        String sourceAndShardPrefix = this.getRequiredParameter(taskContext, DELETE_SHARD_PARAM);
        taskContext.addToCounter("deltaDelete.tasks", 1L);
        Collection<DeltaService.EntryId> entryIds = this.getUnvisitedEntriesTimed(jobRunId, sourceAndShardPrefix, taskContext);
        for (DeltaService.EntryId entryId : entryIds) {
            if (taskContext.isCanceled()) {
                return;
            }
            try {
                taskContext.addToCounter("deltaDelete.unvisitedRecords", 1L);
                Record deleteRecord = DataFactory.DEFAULT.createRecord(entryId.getRecordId(), sourceId);
                this._bulkbuilder.deleteRecord(targetJobName, deleteRecord);
                taskContext.addToCounter("deltaDelete.deletedRecords", 1L);
                this.deleteDeltaEntryTimed(sourceId, entryId, taskContext);
            }
            catch (InvalidRecordException ex) {
                taskContext.getLog().warn("Could not submit delete record '" + entryId + "' to bulkbuilder.", (Throwable)ex);
            }
            catch (DeltaException ex) {
                taskContext.getLog().warn("Could not delete entry for record'" + entryId + "' from delta service.", (Throwable)((Object)ex));
            }
        }
    }

    private void pushUpdatedRecords(TaskContext taskContext, String targetJobName, String jobRunId, DeltaImportStrategy deltaUsage) throws ObjectStoreException, IOException, DeltaException, BulkbuilderException {
        Inputs inputs = taskContext.getInputs();
        RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
        Outputs outputs = taskContext.getOutputs();
        RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
        Record record = recordInput.getRecord();
        while (record != null && !taskContext.isCanceled()) {
            String deltaHash = record.getMetadata().getStringValue("_deltaHash");
            if (deltaHash != null) {
                if (deltaUsage.isDeltaCheckDisabled() || this.checkDeltaStateTimed(jobRunId, record, deltaHash, taskContext) != State.UPTODATE) {
                    this.pushToBulkbuilder(taskContext, targetJobName, record, recordOutput);
                    if (deltaUsage.isSetStateEnabled()) {
                        this.markAsUpdatedTimed(jobRunId, record, deltaHash, taskContext);
                    }
                } else if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Skipping record '" + record.getId() + "'"));
                }
            } else {
                this.pushToBulkbuilder(taskContext, targetJobName, record, recordOutput);
            }
            record = recordInput.getRecord();
        }
    }

    private void pushToBulkbuilder(TaskContext taskContext, String jobName, Record record, RecordOutput recordOutput) throws BulkbuilderException, ObjectStoreException, IOException {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Sending record '" + record.getId() + "'"));
            }
            this._bulkbuilder.addRecord(jobName, record);
            if (recordOutput != null) {
                recordOutput.writeRecord(record);
            }
        }
        catch (InvalidRecordException ex) {
            taskContext.getLog().warn("Could not submit record '" + record.getId() + "' to bulkbuilder.", (Throwable)ex);
        }
    }

    public void setBulkbuilderService(BulkbuilderService service) {
        this._bulkbuilder = service;
    }

    public void unsetBulkbuilderService(BulkbuilderService service) {
        if (this._bulkbuilder == service) {
            this._bulkbuilder = null;
        }
    }
}

