/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence.zk;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.JobRunDefinitions;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.persistence.JobRunListener;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorageException;
import org.eclipse.smila.jobmanager.persistence.zk.JobRunWatcher;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.zookeeper.ZkConcurrentMap;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;
import org.osgi.service.component.ComponentContext;

public class RunStorageZk
implements RunStorage {
    public static final String JOBMANAGER_PREFIX = "/smila/jobmanager";
    public static final String NODE_WORKFLOW_RUNS = "workflow-runs";
    public static final String NODE_BUCKETS = "buckets";
    public static final String NODE_JOBS = "jobs";
    public static final String NODE_DATA = "data";
    public static final String NODE_WORKERDATA = "worker-data";
    public static final String NODE_TASKS = "tasks";
    public static final String NODE_TRANSIENT_BULKS = "transient-bulks";
    public static final String NODE_RUN_DEFINITIONS = "jobrun-definitions";
    public static final String NODE_RUN_DEFINITIONS_JOB = "jobdef";
    public static final String NODE_RUN_DEFINITIONS_WORKFLOW = "wfdef";
    public static final String NODE_RUN_DEFINITIONS_BUCKET = "bucketdef";
    public static final String NODE_WORKFLOW_RUN_FINISHING = "finishing";
    private static final byte ZERO_AS_UTF_8 = 48;
    private static final String UTF_8 = "UTF-8";
    private static final String WORKFLOW_RUN_FINISH_PREFIX = "workflow-run-finish-";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = ValueFormatHelper.getDefaultDateTimeFormat();
    private static final int NO_OF_TRIES_WHEN_CONFLICT = 100;
    private static final int MAX_WAIT_TIME_BETWEEN_TRIES = 10;
    private final Random _waitTimeBetweenTriesGenerator = new Random(System.nanoTime());
    private final Log _log = LogFactory.getLog(this.getClass());
    private ZooKeeperService _zkService;
    private ZkConnection _zk;
    private final IpcAnyReader _anyReader = new IpcAnyReader();
    private final IpcAnyWriter _anyWriter = new IpcAnyWriter(false);

    private String getJobsPath() {
        return "/smila/jobmanager/jobs";
    }

    private String getJobPath(String jobName) {
        return String.valueOf(this.getJobsPath()) + '/' + jobName;
    }

    private String getJobRunDefinitionsPath(String jobName) {
        return String.valueOf(this.getJobPath(jobName)) + '/' + NODE_RUN_DEFINITIONS;
    }

    private String getJobRunDefPathForJobDef(String jobName) {
        return String.valueOf(this.getJobRunDefinitionsPath(jobName)) + '/' + NODE_RUN_DEFINITIONS_JOB;
    }

    private String getJobRunDefPathForWorkflowDef(String jobName) {
        return String.valueOf(this.getJobRunDefinitionsPath(jobName)) + '/' + NODE_RUN_DEFINITIONS_WORKFLOW;
    }

    private String getJobRunDefPathForBucketDefs(String jobName) {
        return String.valueOf(this.getJobRunDefinitionsPath(jobName)) + '/' + NODE_RUN_DEFINITIONS_BUCKET;
    }

    private String getJobDataPath(String jobName) {
        return String.valueOf(this.getJobPath(jobName)) + '/' + NODE_DATA;
    }

    private String getJobWorkerDataPath(String jobName) {
        return String.valueOf(this.getJobPath(jobName)) + '/' + NODE_WORKERDATA;
    }

    private String getJobWorkerDataPath(String jobName, String workerName) {
        return String.valueOf(this.getJobWorkerDataPath(jobName)) + '/' + workerName;
    }

    private String getWorkflowRunsPath(String jobName) {
        return String.valueOf(this.getJobPath(jobName)) + '/' + NODE_WORKFLOW_RUNS;
    }

    private String getWorkflowRunPath(String jobName, String workflowRunId) {
        return String.valueOf(this.getWorkflowRunsPath(jobName)) + '/' + workflowRunId;
    }

    private String getWorkflowRunDataPath(String jobName, String workflowRunId) {
        return String.valueOf(this.getWorkflowRunPath(jobName, workflowRunId)) + "/data";
    }

    private String getWorkflowRunTasksPath(String jobName, String workflowRunId) {
        return String.valueOf(this.getWorkflowRunDataPath(jobName, workflowRunId)) + '/' + NODE_TASKS;
    }

    private String getWorkflowRunBulksPath(String jobName, String workflowRunId) {
        return String.valueOf(this.getWorkflowRunDataPath(jobName, workflowRunId)) + '/' + NODE_TRANSIENT_BULKS;
    }

    private String getTriggerBucketPath(String bucketId) {
        return "/smila/jobmanager/buckets/" + this.encode(bucketId);
    }

    private String getTriggeredJobPath(String bucketId, String jobName) {
        return String.valueOf(this.getTriggerBucketPath(bucketId)) + '/' + jobName;
    }

    private ZkConcurrentMap getJobDataMap(String jobName) throws Exception {
        String jobDataPath = this.getJobDataPath(jobName);
        try {
            return new ZkConcurrentMap(this._zk, jobDataPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private ZkConcurrentMap ensureJobDataMap(String jobName) throws Exception {
        String jobDataPath = this.getJobDataPath(jobName);
        this._zk.ensurePathExists(jobDataPath);
        return new ZkConcurrentMap(this._zk, jobDataPath);
    }

    private void checkCurrentJobRunId(ZkConcurrentMap dataMap, String jobRunId) {
        String currentId = dataMap.getString("jobId");
        if (!jobRunId.equals(currentId)) {
            throw new IllegalArgumentException("Current job run is not '" + jobRunId + "' but '" + currentId + "'.");
        }
    }

    public synchronized String getCurrentTimestamp() {
        return SIMPLE_DATE_FORMAT.format(new Date(System.currentTimeMillis()));
    }

    private Integer addToDataCounter(ZkConcurrentMap dataMap, String counter, int valueToAdd) {
        Integer newValue = null;
        try {
            newValue = dataMap.add(counter, valueToAdd);
            if (newValue == null) {
                this._log.warn((Object)("Could not update data counter '" + counter + "' with value '" + valueToAdd + "', probably due to temporary overload."));
            }
        }
        catch (Exception e) {
            this._log.warn((Object)("Exception while updating data counter '" + counter + "' with value '" + valueToAdd + "': " + e.getMessage()));
        }
        return newValue;
    }

    protected void activate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"activate");
        }
        this._zk = new ZkConnection(this._zkService);
    }

    protected void deactivate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"deactivate");
        }
    }

    public void setZooKeeperService(ZooKeeperService zkService) {
        this._zkService = zkService;
    }

    public void unsetZooKeeperService(ZooKeeperService zkService) {
        if (this._zkService == zkService) {
            this._zkService = null;
        }
    }

    public void startJobRun(String jobName, String jobRunId, JobRunMode jobRunMode, JobRunDefinitions jobRunDefs) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            String workflowRunsPath = this.getWorkflowRunsPath(jobName);
            this._zk.ensurePathExists(workflowRunsPath);
            String currentJobRunId = dataMap.putIfAbsent("jobId", jobRunId);
            if (!jobRunId.equals(currentJobRunId)) {
                throw new IllegalStateException("Another job run with id '" + currentJobRunId + "' already exists.");
            }
            dataMap.put("state", JobState.PREPARING.name());
            dataMap.put("activeWorkflowRunCount", "0");
            dataMap.put("startedWorkflowRunCount", "0");
            dataMap.put("successfulWorkflowRunCount", "0");
            dataMap.put("failedWorkflowRunCount", "0");
            dataMap.put("canceledWorkflowRunCount", "0");
            dataMap.put("createdTaskCount", "0");
            dataMap.put("failedWithoutRetryTaskCount", "0");
            dataMap.put("failedAfterRetryTaskCount", "0");
            dataMap.put("retriedAfterTimeoutTaskCount", "0");
            dataMap.put("retriedAfterErrorTaskCount", "0");
            dataMap.put("successfulTaskCount", "0");
            dataMap.put("canceledTaskCount", "0");
            dataMap.put("obsoleteTaskCount", "0");
            dataMap.put("startTime", this.getCurrentTimestamp());
            dataMap.put("mode", jobRunMode.name());
            this.storeJobRunDefinitions(jobName, jobRunDefs);
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while preparing job run data for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    private void storeJobRunDefinitions(String jobName, JobRunDefinitions jobRunDefs) throws Exception {
        this._zk.ensurePathExists(this.getJobRunDefPathForBucketDefs(jobName));
        byte[] jobDefData = this._anyWriter.writeBinaryObject((Any)jobRunDefs.getJobDefinition().toAny(false));
        this._zk.createNode(this.getJobRunDefPathForJobDef(jobName), jobDefData);
        byte[] workflowfDefData = this._anyWriter.writeBinaryObject((Any)jobRunDefs.getWorkflowDefinition().toAny(false));
        this._zk.createNode(this.getJobRunDefPathForWorkflowDef(jobName), workflowfDefData);
        for (BucketDefinition bucketDef : jobRunDefs.getBucketDefinitions()) {
            byte[] bucketDefData = this._anyWriter.writeBinaryObject((Any)bucketDef.toAny());
            this._zk.createNode(String.valueOf(this.getJobRunDefPathForBucketDefs(jobName)) + '/' + bucketDef.getName(), bucketDefData);
        }
    }

    public boolean finishJobRun(String jobName, String jobRunId) throws RunStorageException {
        ZkConcurrentMap dataMap;
        block4: {
            try {
                dataMap = this.ensureJobDataMap(jobName);
                this.checkCurrentJobRunId(dataMap, jobRunId);
                if (dataMap.replace("state", JobState.RUNNING.name(), JobState.FINISHING.name())) break block4;
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Could not set state to " + JobState.FINISHING + " for job run '" + jobRunId + "' for job '" + jobName + "', someone else may already finishing the run"));
                }
                return false;
            }
            catch (Exception e) {
                throw this.newRunStorageException("Error while setting finish job run data for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
            }
        }
        dataMap.put("finishTime", this.getCurrentTimestamp());
        return true;
    }

    public List<String> cancelJobRun(String jobName, String jobRunId) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            this.checkCurrentJobRunId(dataMap, jobRunId);
            String workflowRunsRoot = this.getWorkflowRunsPath(jobName);
            List workflowRunIds = this._zk.getChildrenSorted(workflowRunsRoot);
            for (String workflowRunId : workflowRunIds) {
                this.cancelWorkflowRun(jobName, jobRunId, workflowRunId, dataMap);
            }
            return workflowRunIds;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while canceling job run data for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    private void cancelWorkflowRun(String jobName, String jobRunId, String workflowRunId, ZkConcurrentMap dataMap) throws RunStorageException {
        try {
            if (this._zk.exists(this.getWorkflowRunPath(jobName, workflowRunId)) != null) {
                boolean doIt;
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Workflow run '" + workflowRunId + "' canceled, preparing finish"));
                }
                if (doIt = this.prepareToFinishWorkflowRun(jobName, jobRunId, workflowRunId)) {
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("Workflow run '" + workflowRunId + "' canceled, aggregating counters and deleting workflow run"));
                    }
                    this.addToDataCounter(dataMap, "canceledWorkflowRunCount", 1);
                    this.addToDataCounter(dataMap, "activeWorkflowRunCount", -1);
                    this.deleteWorkflowRunData(jobName, jobRunId, workflowRunId);
                    this.deleteWorkflowRun(jobName, jobRunId, workflowRunId);
                }
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Workflow run '" + workflowRunId + "' canceled"));
                }
            }
        }
        catch (Exception e) {
            this._log.warn((Object)("Error while canceling workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'."), (Throwable)e);
        }
    }

    public void deleteJobRun(String jobName, String jobRunId) throws RunStorageException {
        try {
            this._zk.deleteTree(this.getWorkflowRunsPath(jobName));
            this._zk.deleteTree(this.getJobWorkerDataPath(jobName));
            this._zk.deleteTree(this.getJobRunDefinitionsPath(jobName));
            this._zk.deleteTree(this.getJobPath(jobName));
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while deleting job run with id '" + jobRunId + "' for job '" + jobName + "'.", e);
        }
    }

    public Collection<String> getCurrentJobs() throws RunStorageException {
        try {
            String path = this.getJobsPath();
            this._zk.ensurePathExists(path);
            return this._zk.getChildrenSorted(path);
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting job names.", e);
        }
    }

    public String getJobRunId(String jobName) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.getJobDataMap(jobName);
            if (dataMap != null) {
                return dataMap.getString("jobId");
            }
            return null;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting job run id for job '" + jobName + "'.", e);
        }
    }

    public AnyMap getJobRunData(String jobName, boolean returnDetails) throws RunStorageException {
        try {
            AnyMap result = DataFactory.DEFAULT.createAnyMap();
            ZkConcurrentMap dataMap = this.getJobDataMap(jobName);
            if (dataMap != null) {
                this.addJobRunDataBasicSections(result, dataMap, jobName);
                this.addJobRunDataWorkerSection(result, jobName);
                this.addJobRunDataDefinitionSection(result, jobName, returnDetails);
            }
            return result;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting job run data for job '" + jobName + "'.", e);
        }
    }

    private void addJobRunDataBasicSections(AnyMap result, ZkConcurrentMap dataMap, String jobName) throws Exception {
        AnyMap workflowRuns = DataFactory.DEFAULT.createAnyMap();
        AnyMap tasks = DataFactory.DEFAULT.createAnyMap();
        Set keySet = dataMap.keySet();
        for (String key : keySet) {
            String value = dataMap.getString(key);
            if (value == null) continue;
            if (key.toLowerCase(Locale.ENGLISH).endsWith("taskcount")) {
                try {
                    tasks.put(key, (Number)Integer.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    tasks.put(key, value);
                }
                continue;
            }
            if (key.toLowerCase(Locale.ENGLISH).endsWith("workflowruncount")) {
                try {
                    workflowRuns.put(key, (Number)Integer.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    workflowRuns.put(key, value);
                }
                continue;
            }
            result.put(key, value);
        }
        result.put("workflowRuns", (Any)workflowRuns);
        result.put(NODE_TASKS, (Any)tasks);
    }

    private void addJobRunDataWorkerSection(AnyMap result, String jobName) throws Exception {
        String workerDataNode = this.getJobWorkerDataPath(jobName);
        if (this._zk.exists(workerDataNode) != null) {
            AnyMap workerData = DataFactory.DEFAULT.createAnyMap();
            List workers = this._zk.getChildrenSorted(workerDataNode);
            if (workers != null) {
                for (String worker : workers) {
                    AnyMap workerAny = this.getWorkerData(jobName, worker);
                    workerData.put(worker, (Any)workerAny);
                }
            }
            result.put("worker", (Any)workerData);
        }
    }

    private void addJobRunDataDefinitionSection(AnyMap result, String jobName, boolean returnDetails) throws Exception {
        String runDefsNode = this.getJobRunDefinitionsPath(jobName);
        if (this._zk.exists(runDefsNode) != null) {
            try {
                byte[] jobDefBytes = this._zk.getData(this.getJobRunDefPathForJobDef(jobName));
                AnyMap jobDefAny = (AnyMap)this._anyReader.readBinaryObject(jobDefBytes);
                result.put("jobDefinition", (Any)jobDefAny);
                if (returnDetails) {
                    byte[] workflowDefBytes = this._zk.getData(this.getJobRunDefPathForWorkflowDef(jobName));
                    AnyMap workflowDefAny = (AnyMap)this._anyReader.readBinaryObject(workflowDefBytes);
                    result.put("workflowDefinition", (Any)workflowDefAny);
                    List bucketNodes = this._zk.getChildrenSorted(this.getJobRunDefPathForBucketDefs(jobName));
                    if (!bucketNodes.isEmpty()) {
                        AnySeq bucketDefs = DataFactory.DEFAULT.createAnySeq();
                        result.put("bucketDefinitions", (Any)bucketDefs);
                        for (String bucketNode : bucketNodes) {
                            byte[] bucketDefBytes = this._zk.getData(String.valueOf(this.getJobRunDefPathForBucketDefs(jobName)) + '/' + bucketNode);
                            AnyMap bucketDefAny = (AnyMap)this._anyReader.readBinaryObject(bucketDefBytes);
                            bucketDefs.add((Object)bucketDefAny);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this._log.warn((Object)("Failed to read job run definition data for job '" + jobName + "'"), (Throwable)ex);
            }
        }
    }

    public AnyMap getWorkflowRunData(String jobName, String workflowRunId) throws RunStorageException {
        try {
            String workflowRunPath = this.getWorkflowRunPath(jobName, workflowRunId);
            if (this._zk.exists(workflowRunPath) == null) {
                throw new RunStorageException("Workflow run '" + workflowRunId + "' does not exist for job '" + jobName + "'", false);
            }
            AnyMap workflowRunData = DataFactory.DEFAULT.createAnyMap();
            String tasksPath = this.getWorkflowRunTasksPath(jobName, workflowRunId);
            Stat tasksStat = this._zk.exists(tasksPath);
            if (tasksStat != null) {
                workflowRunData.put("activeTaskCount", (Number)tasksStat.getNumChildren());
            } else {
                workflowRunData.put("activeTaskCount", (Number)0);
            }
            String bulksPath = this.getWorkflowRunBulksPath(jobName, workflowRunId);
            Stat bulksStat = this._zk.exists(bulksPath);
            if (bulksStat != null) {
                workflowRunData.put("transientBulkCount", (Number)bulksStat.getNumChildren());
            } else {
                workflowRunData.put("transientBulkCount", (Number)0);
            }
            return workflowRunData;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting workflow run data for run '" + workflowRunId + "' in job '" + jobName + "'.", e);
        }
    }

    public AnyMap getWorkerData(String jobName, String worker) {
        try {
            String workerPath = this.getJobWorkerDataPath(jobName, worker);
            byte[] workerData = this._zk.getData(workerPath);
            if (workerData != null && workerData.length > 0) {
                AnyMap workerMap = (AnyMap)this._anyReader.readBinaryObject(workerData);
                AnyMap sortedWorkerMap = workerMap.getFactory().createAnyMap();
                if (workerMap.containsKey((Object)"warnCount")) {
                    sortedWorkerMap.put("warnCount", (Any)workerMap.remove((Object)"warnCount"));
                }
                TreeSet sortedKeys = new TreeSet(workerMap.keySet());
                for (String key : sortedKeys) {
                    sortedWorkerMap.put(key, (Any)workerMap.get((Object)key));
                }
                return sortedWorkerMap;
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Failed to read worker data for '" + worker + "' in job '" + jobName), (Throwable)ex);
        }
        return DataFactory.DEFAULT.createAnyMap();
    }

    public JobState getJobState(String jobName) throws RunStorageException {
        try {
            String s;
            ZkConcurrentMap dataMap = this.getJobDataMap(jobName);
            if (dataMap != null && (s = dataMap.getString("state")) != null) {
                return JobState.valueOf((String)s);
            }
            return null;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting job state for job '" + jobName + "'.", e);
        }
    }

    public JobState getJobState(String jobName, String jobRunId) throws RunStorageException {
        try {
            String state;
            String runId;
            ZkConcurrentMap dataMap = this.getJobDataMap(jobName);
            if (dataMap != null && jobRunId.equals(runId = dataMap.getString("jobId")) && (state = dataMap.getString("state")) != null) {
                return JobState.valueOf((String)state);
            }
            return null;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting job state for job '" + jobName + "'.", e);
        }
    }

    public JobRunInfo getJobRunInfo(String jobName) throws RunStorageException {
        try {
            String state;
            String jobRunId;
            ZkConcurrentMap dataMap = this.getJobDataMap(jobName);
            if (dataMap != null && (jobRunId = dataMap.getString("jobId")) != null && (state = dataMap.getString("state")) != null) {
                return new JobRunInfo(jobRunId, JobState.valueOf((String)state));
            }
            return null;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting job state for job '" + jobName + "'.", e);
        }
    }

    public void setJobState(String jobName, String jobRunId, JobState jobState) throws RunStorageException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Setting job state for job run '" + jobRunId + "' for job '" + jobName + "' to state " + jobState));
        }
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            this.checkCurrentJobRunId(dataMap, jobRunId);
            dataMap.put("state", jobState.name());
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while setting job state '" + jobState + "' for job '" + jobName + "'.", e);
        }
    }

    public boolean setJobState(String jobName, String jobRunId, JobState expectedState, JobState newState) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            this.checkCurrentJobRunId(dataMap, jobRunId);
            boolean result = dataMap.replace("state", expectedState.name(), newState.name());
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Changing job state for job run '" + jobRunId + "' for job '" + jobName + "' to state " + newState + " while expecting state " + expectedState + " returned result: " + result));
            }
            return result;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while setting new job state '" + newState + "' for expected job state '" + expectedState + "' of  job '" + jobName + "'.", e);
        }
    }

    public String startWorkflowRun(String jobName, String jobRunId) throws RunStorageException {
        return this.startWorkflowRun(jobName, jobRunId, "startedWorkflowRunCount");
    }

    public String startCompletionWorkflowRun(String jobName, String jobRunId) throws RunStorageException {
        return this.startWorkflowRun(jobName, jobRunId, "startedCompletionWorkflowRunCount");
    }

    private String startWorkflowRun(String jobName, String jobRunId, String workflowStartCounter) throws RunStorageException {
        String newWorkflowRunId = null;
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            Integer newValue = this.addToDataCounter(dataMap, workflowStartCounter, 1);
            if (newValue == null) {
                throw new RunStorageException("Could not create workflow run id for job '" + jobName + "', probably due to temporary overload.", true);
            }
            newWorkflowRunId = String.valueOf(newValue);
            String workflowRunPath = this.getWorkflowRunPath(jobName, newWorkflowRunId);
            this._zk.ensurePathExists(workflowRunPath);
            this._zk.ensurePathExists(this.getWorkflowRunTasksPath(jobName, newWorkflowRunId));
            this._zk.ensurePathExists(this.getWorkflowRunBulksPath(jobName, newWorkflowRunId));
            this.addToDataCounter(dataMap, "activeWorkflowRunCount", 1);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Workflow run '" + newWorkflowRunId + "' for job run '" + jobRunId + "' started"));
            }
            return newWorkflowRunId;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while starting workflow run with id'" + newWorkflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean prepareToFinishWorkflowRun(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            String currentJobRunId = dataMap.getString("jobId");
            if (currentJobRunId.equals(jobRunId)) {
                String finishingFlagPath;
                String workflowRunPath = this.getWorkflowRunPath(jobName, workflowRunId);
                if (this._zk.exists(workflowRunPath) == null || this._zk.exists(finishingFlagPath = String.valueOf(workflowRunPath) + '/' + NODE_WORKFLOW_RUN_FINISHING) != null) return false;
                dataMap.remove(WORKFLOW_RUN_FINISH_PREFIX + workflowRunId);
                try {
                    this._zk.createNode(finishingFlagPath, null, CreateMode.EPHEMERAL);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    if (!this._log.isInfoEnabled()) return false;
                    this._log.info((Object)("Someone else is already finishing workflow run '" + workflowRunId + "'"));
                    return false;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    if (!this._log.isInfoEnabled()) return false;
                    this._log.info((Object)("Someone else already deleted workflow run '" + workflowRunId + "'"));
                    return false;
                }
                String itSMe = UUID.randomUUID().toString();
                String whoIsIt = dataMap.putIfAbsent(WORKFLOW_RUN_FINISH_PREFIX + workflowRunId, itSMe);
                if (!itSMe.equals(whoIsIt) || this._zk.exists(workflowRunPath) == null) return false;
                return true;
            }
            this._log.warn((Object)("Could not prepare to finish workflow run '" + workflowRunId + "' for a job run '" + jobRunId + "' of job '" + jobName + "'. The Job Run has already been removed, has probably been cancelled."));
            return false;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while preparing to finish workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void successfulWorkflowRun(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            String currentJobRunId = dataMap.getString("jobId");
            if (currentJobRunId.equals(jobRunId)) {
                this.addToDataCounter(dataMap, "activeWorkflowRunCount", -1);
                this.addToDataCounter(dataMap, "successfulWorkflowRunCount", 1);
            } else {
                this._log.warn((Object)("Finishing workflow run '" + workflowRunId + "' for a job run '" + jobRunId + "' of job '" + jobName + "'. The Job Run has already been removed, has probably been cancelled."));
            }
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while counting successful workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void failedWorkflowRun(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            String currentJobRunId = dataMap.getString("jobId");
            if (currentJobRunId.equals(jobRunId)) {
                this.addToDataCounter(dataMap, "activeWorkflowRunCount", -1);
                this.addToDataCounter(dataMap, "failedWorkflowRunCount", 1);
            }
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while counting failed workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void deleteWorkflowRunData(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        try {
            String tasksPath = this.getWorkflowRunTasksPath(jobName, workflowRunId);
            int noOfTasks = this._zk.getChildrenSorted(tasksPath).size();
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            this.addToDataCounter(dataMap, "canceledTaskCount", noOfTasks);
        }
        catch (Exception e) {
            this._log.warn((Object)("Exception while updating job run data counter 'canceledTaskCount': " + e.getMessage()));
        }
        try {
            this._zk.deleteTree(this.getWorkflowRunDataPath(jobName, workflowRunId));
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while deleting data for workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void deleteWorkflowRun(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        try {
            this._zk.deleteTree(this.getWorkflowRunPath(jobName, workflowRunId));
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            this.checkCurrentJobRunId(dataMap, jobRunId);
            dataMap.remove(WORKFLOW_RUN_FINISH_PREFIX + workflowRunId);
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while deleting workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAndCleanupActiveWorkflowRuns(String jobName, String jobRunId) throws RunStorageException {
        String workflowRunPath = this.getWorkflowRunsPath(jobName);
        try {
            Stat stat = this._zk.exists(workflowRunPath);
            if (stat == null) {
                return false;
            }
            try {
                List wfRuns = this._zk.getChildrenSorted(workflowRunPath);
                if (wfRuns.size() == 0) {
                    return false;
                }
                ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
                boolean foundActiveWfRun = false;
                Iterator iterator = wfRuns.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return foundActiveWfRun;
                    }
                    String wfRunId = (String)iterator.next();
                    if (this._zk.exists(String.valueOf(workflowRunPath) + '/' + NODE_WORKFLOW_RUN_FINISHING) != null) {
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("Someone else is already finishing workflow run '" + wfRunId + "'"));
                        }
                        return true;
                    }
                    if (dataMap.containsKey(WORKFLOW_RUN_FINISH_PREFIX + wfRunId)) {
                        boolean doIt;
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("Workflow run '" + wfRunId + "' finishing was interrupted, preparing for take over"));
                        }
                        if (!(doIt = this.prepareToFinishWorkflowRun(jobName, jobRunId, wfRunId))) continue;
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("Taking over the finishing of workflow run '" + wfRunId + "'"));
                        }
                        this.deleteWorkflowRunData(jobName, jobRunId, wfRunId);
                        this.deleteWorkflowRun(jobName, jobRunId, wfRunId);
                        continue;
                    }
                    foundActiveWfRun = true;
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                return false;
            }
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting info whether job run with id '" + jobRunId + "' has active workflow runs for job '" + jobName + "'.", e);
        }
    }

    public boolean hasWorkflowRun(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        String workflowRunPath = this.getWorkflowRunPath(jobName, workflowRunId);
        try {
            Stat stat = this._zk.exists(workflowRunPath);
            return stat != null;
        }
        catch (KeeperException e) {
            throw this.newRunStorageException("Error while getting info job run with id '" + jobRunId + "' has active workflow run '" + workflowRunId + "' for job '" + jobName + "'.", e);
        }
    }

    public boolean hasTasks(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        try {
            String tasksPath = this.getWorkflowRunTasksPath(jobName, workflowRunId);
            if (this._zk.exists(tasksPath) != null) {
                try {
                    int noOfTasks = this._zk.getChildrenSorted(tasksPath).size();
                    return noOfTasks > 0;
                }
                catch (KeeperException.NoNodeException noNodeException) {}
            }
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting info whether workflow run with id '" + workflowRunId + "' has tasks for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
        return false;
    }

    public void startTask(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId) throws RunStorageException {
        this.startTask(jobName, jobRunId, workflowRunId, stepId, taskId, 0);
    }

    public void startTask(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId, int numberOfRetries) throws RunStorageException {
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            if (dataMap.containsKey(WORKFLOW_RUN_FINISH_PREFIX + workflowRunId)) {
                throw new IllegalStateException("Tried to store a task for a finished workflow run");
            }
            String taskPath = String.valueOf(this.getWorkflowRunTasksPath(jobName, workflowRunId)) + "/" + taskId;
            this._zk.createNode(taskPath, String.valueOf(numberOfRetries).getBytes(UTF_8));
            this.addToDataCounter(dataMap, "createdTaskCount", 1);
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while storing task '" + taskId + "' in step '" + stepId + "' of workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void startTasks(String jobName, String jobRunId, String workflowRunId, Collection<Task> tasks) throws RunStorageException {
        byte[] taskData;
        String workflowRunTaskPath = this.getWorkflowRunTasksPath(jobName, workflowRunId);
        try {
            taskData = "0".getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            taskData = new byte[]{48};
        }
        try {
            ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
            if (dataMap.containsKey(WORKFLOW_RUN_FINISH_PREFIX + workflowRunId)) {
                throw new IllegalStateException("Tried to store a task for a finished workflow run");
            }
            for (Task task : tasks) {
                String taskPath = String.valueOf(workflowRunTaskPath) + "/" + task.getTaskId();
                this._zk.createNode(taskPath, taskData);
            }
            this.addToDataCounter(dataMap, "createdTaskCount", tasks.size());
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while storing tasks of workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void finishTask(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId, Map<String, Number> workerCounter, Map<String, String> properties) throws RunStorageException {
        this.deleteTask(jobName, jobRunId, workflowRunId, stepId, taskId, "successfulTaskCount");
        if (workerCounter == null) {
            workerCounter = new HashMap<String, Number>(1);
        }
        workerCounter.put("successfulTaskCount", 1);
        this.updateWorkerData(jobName, stepId, workerCounter, properties);
    }

    public void obsoleteTask(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId, Map<String, String> properties) throws RunStorageException {
        this.deleteTask(jobName, jobRunId, workflowRunId, stepId, taskId, "obsoleteTaskCount");
        HashMap<String, Number> workerCounter = new HashMap<String, Number>(1);
        workerCounter.put("obsoleteTaskCount", 1);
        this.updateWorkerData(jobName, stepId, workerCounter, properties);
    }

    public void failedTask(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId, boolean failedAfterRetry, Map<String, String> properties) throws RunStorageException {
        HashMap<String, Number> workerCounter = new HashMap<String, Number>(1);
        if (failedAfterRetry) {
            this.deleteTask(jobName, jobRunId, workflowRunId, stepId, taskId, "failedAfterRetryTaskCount");
            workerCounter.put("failedAfterRetryTaskCount", 1);
        } else {
            this.deleteTask(jobName, jobRunId, workflowRunId, stepId, taskId, "failedWithoutRetryTaskCount");
            workerCounter.put("failedWithoutRetryTaskCount", 1);
        }
        this.updateWorkerData(jobName, stepId, workerCounter, properties);
    }

    public void retriedTask(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId, boolean retryByWorker, Map<String, String> properties) throws RunStorageException {
        HashMap<String, Number> workerCounter = new HashMap<String, Number>(1);
        if (retryByWorker) {
            this.deleteTask(jobName, jobRunId, workflowRunId, stepId, taskId, "retriedAfterErrorTaskCount");
            workerCounter.put("retriedAfterErrorTaskCount", 1);
        } else {
            this.deleteTask(jobName, jobRunId, workflowRunId, stepId, taskId, "retriedAfterTimeoutTaskCount");
            workerCounter.put("retriedAfterTimeoutTaskCount", 1);
        }
        this.updateWorkerData(jobName, stepId, workerCounter, properties);
    }

    private void updateWorkerData(String jobName, String worker, Map<String, Number> workerCounters, Map<String, String> properties) {
        try {
            this._zk.ensurePathExists(this.getJobWorkerDataPath(jobName));
            String workerDataNode = this.getJobWorkerDataPath(jobName, worker);
            int tries = 0;
            do {
                ++tries;
                Stat stat = this._zk.exists(workerDataNode);
                if (stat == null) {
                    AnyMap data = DataFactory.DEFAULT.createAnyMap();
                    byte[] dataBytes = this._anyWriter.writeBinaryObject((Any)data);
                    try {
                        this._zk.createNode(workerDataNode, dataBytes);
                        stat = this._zk.exists(workerDataNode);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                        stat = this._zk.exists(workerDataNode);
                    }
                }
                int version = stat.getVersion();
                byte[] workerData = this._zk.getData(workerDataNode);
                AnyMap data = (AnyMap)this._anyReader.readBinaryObject(workerData);
                for (Map.Entry<String, Number> counterEntry : workerCounters.entrySet()) {
                    Number valueToAdd = counterEntry.getValue();
                    String counter = counterEntry.getKey();
                    if (data.get((Object)counter) != null) {
                        Value old = data.getValue(counter);
                        Number newValue = null;
                        if (old.isDouble()) {
                            newValue = old.asDouble() + valueToAdd.doubleValue();
                        } else if (old.isLong()) {
                            newValue = old.asLong() + valueToAdd.longValue();
                        }
                        data.put(counter, newValue);
                        continue;
                    }
                    data.put(counter, valueToAdd);
                }
                byte[] dataBytes = this._anyWriter.writeBinaryObject((Any)this.adjustWorkerStartAndEndTimeFromProperties(data, properties));
                try {
                    this._zk.setData(workerDataNode, dataBytes, version);
                    return;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                }
                catch (KeeperException.BadVersionException badVersionException) {}
                Thread.sleep(this._waitTimeBetweenTriesGenerator.nextInt(10));
            } while (tries <= 100);
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("Too much conflicts while updating worker data for worker '" + worker + "', data: " + workerCounters));
            }
        }
        catch (Exception e) {
            this._log.warn((Object)("Exception while updating worker data for worker '" + worker + "', data '" + workerCounters + "': " + e.getMessage()));
        }
    }

    private AnyMap adjustWorkerStartAndEndTimeFromProperties(AnyMap data, Map<String, String> properties) {
        if (properties != null) {
            String dateFromProperty;
            String currentDateTime;
            if (properties.containsKey("startTime")) {
                if (data.containsKey((Object)"startTime") && data.get((Object)"startTime") != null) {
                    currentDateTime = data.getStringValue("startTime");
                    dateFromProperty = properties.get("startTime");
                    if (dateFromProperty != null && dateFromProperty.compareTo(currentDateTime) < 0) {
                        data.put("startTime", dateFromProperty);
                    }
                } else {
                    data.put("startTime", properties.get("startTime"));
                }
            }
            if (properties.containsKey("endTime")) {
                if (data.containsKey((Object)"endTime") && data.get((Object)"endTime") != null) {
                    currentDateTime = data.getStringValue("endTime");
                    dateFromProperty = properties.get("endTime");
                    if (dateFromProperty != null && dateFromProperty.compareTo(currentDateTime) > 0) {
                        data.put("endTime", dateFromProperty);
                    }
                } else {
                    data.put("endTime", properties.get("endTime"));
                }
            }
        }
        return data;
    }

    private void deleteTask(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId, String taskCounter) throws RunStorageException {
        try {
            String taskPath = String.valueOf(this.getWorkflowRunTasksPath(jobName, workflowRunId)) + "/" + taskId;
            if (this._zk.exists(taskPath) != null) {
                ZkConcurrentMap dataMap = this.ensureJobDataMap(jobName);
                this.addToDataCounter(dataMap, taskCounter, 1);
            }
            this._zk.deleteNode(taskPath);
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while deleting task '" + taskId + "' in step '" + stepId + "' of workflow run '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public boolean hasTask(String jobName, String workflowRunId, String taskId) throws RunStorageException {
        try {
            String jobPath = String.valueOf(this.getWorkflowRunTasksPath(jobName, workflowRunId)) + "/" + taskId;
            return this._zk.exists(jobPath) != null;
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while checking existence of task '" + taskId + "' of workflow run with id '" + workflowRunId + "' for job '" + jobName + "'.", e);
        }
    }

    public int getTaskRetries(String jobName, String jobRunId, String workflowRunId, String stepId, String taskId) throws RunStorageException {
        try {
            String jobPath = String.valueOf(this.getWorkflowRunTasksPath(jobName, workflowRunId)) + "/" + taskId;
            return Integer.parseInt(new String(this._zk.getData(jobPath), UTF_8));
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting retry count for task '" + taskId + "' in step '" + stepId + "' of workflow run with id '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void addTransientBulk(String jobName, String jobRunId, String workflowRunId, String bulk) throws RunStorageException {
        try {
            String bulkPath = String.valueOf(this.getWorkflowRunBulksPath(jobName, workflowRunId)) + "/" + this.encode(bulk);
            this._zk.createNode(bulkPath, null);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Transient bulk '" + bulk + "' in workflow run '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "' has been stored before."));
            }
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while adding bulk '" + bulk + "' in workflow run '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public Collection<String> getTransientBulks(String jobName, String jobRunId, String workflowRunId) throws RunStorageException {
        String bulksPath = this.getWorkflowRunBulksPath(jobName, workflowRunId);
        try {
            try {
                List encodedBulks = this._zk.getChildrenSorted(bulksPath);
                ArrayList<String> bulks = new ArrayList<String>(encodedBulks.size());
                for (String encodedBulk : encodedBulks) {
                    bulks.add(this.decode(encodedBulk));
                }
                return bulks;
            }
            catch (KeeperException.NoNodeException noNodeException) {
                return Collections.emptyList();
            }
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error while getting bulks of workflow run '" + workflowRunId + "' for job '" + jobName + "' with run id '" + jobRunId + "'.", e);
        }
    }

    public void clear() throws RunStorageException {
        try {
            List nodes = this._zk.getChildrenSorted(JOBMANAGER_PREFIX);
            for (String node : nodes) {
                try {
                    this._zk.deleteTree("/smila/jobmanager/" + node);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw this.newRunStorageException("Error in clear().", e);
        }
    }

    public Collection<String> getTriggeredJobs(String bucketId) throws RunStorageException {
        String path = this.getTriggerBucketPath(bucketId);
        try {
            if (this._zk.exists(path) != null) {
                return this._zk.getChildrenSorted(path);
            }
            return Collections.emptyList();
        }
        catch (Exception ex) {
            throw this.newRunStorageException("Error getting job names triggered by bucket '" + bucketId + "'", ex);
        }
    }

    public void addJobTrigger(String bucketId, String jobName) throws RunStorageException {
        String path = this.getTriggeredJobPath(bucketId, jobName);
        try {
            this._zk.ensurePathExists(path);
        }
        catch (Exception ex) {
            throw this.newRunStorageException("Error setting job '" + jobName + "' as triggered by bucket '" + bucketId + "'", ex);
        }
    }

    public void removeJobTrigger(String bucketId, String jobName) throws RunStorageException {
        String path = this.getTriggeredJobPath(bucketId, jobName);
        try {
            if (this._zk.exists(path) != null) {
                this._zk.deleteNode(path);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception ex) {
            throw this.newRunStorageException("Error setting job '" + jobName + "' as triggered by bucket '" + bucketId + "'", ex);
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("UTF-8 MUST BE SUPPORTED!", ex);
        }
    }

    private String decode(String encodedValue) {
        try {
            return URLDecoder.decode(encodedValue, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("UTF-8 MUST BE SUPPORTED!", ex);
        }
    }

    private RunStorageException newRunStorageException(String message, Throwable cause) {
        return new RunStorageException(message, cause, this.isRecoverable(cause));
    }

    private boolean isRecoverable(Throwable cause) {
        if (cause instanceof RuntimeException) {
            return true;
        }
        return cause instanceof KeeperException.ConnectionLossException || cause instanceof KeeperException.OperationTimeoutException || cause instanceof KeeperException.SessionExpiredException || cause instanceof KeeperException.SessionMovedException;
    }

    public void registerJobRunListener(JobRunListener jobRunListener, String jobName) {
        JobRunWatcher watcher = new JobRunWatcher(jobRunListener);
        try {
            this._zk.exists("/smila/jobmanager/jobs/" + jobName, (Watcher)watcher);
        }
        catch (KeeperException e) {
            this._log.warn((Object)("Unable to register job run listener resp. set watcher for job " + jobName), (Throwable)e);
        }
    }
}

