/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.client.utils.URIUtils;

public class UriHelper {
    public static String makeAbsolute(String baseUriString, String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        if (uri.isAbsolute()) {
            return uri.toString();
        }
        URI baseUri = new URI(baseUriString);
        if (!baseUri.isAbsolute()) {
            return null;
        }
        URI absUri = URIUtils.resolve((URI)baseUri, (URI)uri);
        return absUri.toString();
    }

    public static String normalizeUrl(String urlString) throws URISyntaxException {
        int port;
        URI uri = null;
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                URL url = new URL(urlString);
                uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), null);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (uri.isOpaque()) {
            return null;
        }
        URI u = uri.normalize();
        String scheme = u.getScheme();
        if (scheme != null) {
            scheme = scheme.toLowerCase();
        }
        String userInfo = u.getUserInfo();
        String host = u.getHost();
        if (host != null) {
            host = host.toLowerCase();
        }
        if ((port = u.getPort()) == 80) {
            port = -1;
        }
        String path = u.getPath();
        String query = u.getQuery();
        String normalizedUrl = new URI(scheme, userInfo, host, port, path, query, null).toString();
        return normalizedUrl;
    }
}

