/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.RequestTable;
import org.eclipse.smila.processing.bpel.util.ConfigurationHelper;
import org.eclipse.smila.processing.bpel.util.MessageHelper;

public class RequestTableImpl
implements RequestTable {
    private final AtomicLong _requestIdSequence = new AtomicLong(0L);
    private final Map<String, Blackboard> _blackboards = new ConcurrentHashMap<String, Blackboard>();
    private final Map<String, Exception> _pipeletExceptions = new HashMap<String, Exception>();
    private MessageHelper _messageHelper;
    private final Log _log = LogFactory.getLog(this.getClass());

    protected void activate() {
        try {
            Properties properties = ConfigurationHelper.readConfiguration();
            this._messageHelper = new MessageHelper(properties);
        }
        catch (IOException ex) {
            this._log.error((Object)("Could not read configuration property file processor.properties: " + ex.toString()));
        }
    }

    @Override
    public String initRequest(Blackboard blackboard) {
        String requestId = Long.toString(this._requestIdSequence.getAndIncrement());
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Starting to process request ID = " + requestId));
        }
        this._blackboards.put(requestId, blackboard);
        return requestId;
    }

    @Override
    public Blackboard getBlackboard(String id) throws ProcessingException {
        Blackboard blackboard = this._blackboards.get(id);
        if (blackboard == null) {
            throw new ProcessingException("Blackboard for request " + id + " is not registered anymore.");
        }
        return blackboard;
    }

    @Override
    public Exception getPipeletException(String requestId) {
        return this._pipeletExceptions.get(requestId);
    }

    @Override
    public void setPipeletException(String requestId, Exception ex) {
        this._pipeletExceptions.put(requestId, ex);
    }

    @Override
    public void cleanupRequest(String requestId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Cleaning up request ID = " + requestId));
        }
        this._blackboards.remove(requestId);
        this._pipeletExceptions.remove(requestId);
    }

    @Override
    public MessageHelper getMessageHelper() {
        return this._messageHelper;
    }
}

