/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.utils.config.ConfigUtils;

public final class ConfigurationHelper {
    public static final String BUNDLE_NAME = "org.eclipse.smila.processing.bpel";
    public static final String CONFIGURATION_DIR = "configuration/org.eclipse.smila.processing.bpel";
    public static final String CONFIGURATION_FILE = "processor.properties";
    public static final String PROP_PIPELINE_DIR = "pipeline.dir";
    public static final String DEFAULT_PIPELINE_DIR = "pipelines";
    public static final String PROP_PREFIX_ODE = "ode.";
    static final String PROP_RECORD_FILTER = "record.filter";

    private ConfigurationHelper() {
        throw new IllegalStateException();
    }

    public static Properties readConfiguration() throws IOException {
        Properties properties = new Properties();
        InputStream configurationFileStream = null;
        try {
            configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_NAME, (String)CONFIGURATION_FILE);
            properties.load(configurationFileStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException ex) {
            throw new IOException("Could not read configuration property file processor.properties: " + ex.toString());
        }
        finally {
            IOUtils.closeQuietly((InputStream)configurationFileStream);
        }
    }

    public static String getPipelineDirectory() throws IOException {
        Properties properties = ConfigurationHelper.readConfiguration();
        return properties.getProperty(PROP_PIPELINE_DIR, DEFAULT_PIPELINE_DIR);
    }
}

