/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.security.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPSearchResults;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.security.SecurityException;
import org.eclipse.smila.security.SecurityResolver;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class LDAPSecurityResolver
implements SecurityResolver {
    public static final String BUNDLE_NAME = "org.eclipse.smila.security.ldap";
    public static final String CONFIGURATION_FILE = "ldap.properties";
    public static final String PROPERTY_LDAP_HOST = "ldap.host";
    public static final String PROPERTY_LDAP_PORT = "ldap.port";
    public static final String PROPERTY_LDAP_LOGIN = "ldap.login";
    public static final String PROPERTY_LDAP_PASSWORD = "ldap.password";
    public static final String PROPERTY_LDAP_BASE_DN = "ldap.base.dn";
    public static final String PROPERTY_LDAP_USER_NAME_ATTRIBUTE = "ldap.username.attribute";
    public static final String DEFAULT_LDAP_USER_NAME_ATTRIBUTE = "cn";
    public static final String LDAP_ATTRIBUTE_OBJECT_CLASS = "objectClass";
    public static final String LDAP_ATTRIBUTE_MEMBER = "member";
    public static final String LDAP_ATTRIBUTE_UNIQUE_MEMBER = "uniqueMember";
    public static final String LDAP_ATTRIBUTE_MEMBER_OF = "memberOf";
    public static final String LDAP_OBJECT_NAME_GROUP = "group";
    public static final String LDAP_OBJECT_NAME_GROUP_OF_NAMES = "groupOfNames";
    public static final String LDAP_OBJECT_NAME_GROUP_OF_UNIQUE_NAMES = "groupOfUniqueNames";
    public static final String LDAP_OBJECT_NAME_DYNAMIC_GROUP = "dynamicGroup";
    public static final String LDAP_OBJECT_NAME_DYNAMIC_GROUP_AUX = "dynamicGroupAux";
    private final Log _log = LogFactory.getLog(LDAPSecurityResolver.class);
    private Properties _properties;
    private LDAPConnection _ldapConnection;

    public LDAPSecurityResolver() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"creating instance of LDAPSecurityResolver");
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        try {
            this.readConfiguration();
            this.ensureConnection();
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error activating LDAPSecurityResolver service", (Throwable)e);
            }
            throw e;
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"started LDAPSecurityResolver service");
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        if (this._properties != null) {
            this._properties.clear();
            this._properties = null;
        }
        if (this._ldapConnection != null) {
            this._ldapConnection.disconnect();
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"deactivated LDAPSecurityResolver service");
        }
    }

    public String resolvePrincipal(String name) throws SecurityException {
        if (name == null) {
            throw new SecurityException("parameter name is null");
        }
        this.ensureConnection();
        try {
            String filter = String.valueOf(this._properties.getProperty(PROPERTY_LDAP_USER_NAME_ATTRIBUTE, DEFAULT_LDAP_USER_NAME_ATTRIBUTE)) + "=" + name;
            LDAPSearchResults searchResults = this._ldapConnection.search(this._properties.getProperty(PROPERTY_LDAP_BASE_DN), 2, filter, null, true);
            if (searchResults != null && searchResults.hasMore()) {
                LDAPEntry entry = searchResults.next();
                String dn = entry.getDN();
                return dn;
            }
            return null;
        }
        catch (Exception e) {
            String msg = "error resolving name " + name;
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public Map<String, Collection<String>> getProperties(String principal) throws SecurityException {
        if (principal == null) {
            throw new SecurityException("parameter principal is null");
        }
        this.ensureConnection();
        try {
            HashMap<String, Collection<String>> properties = new HashMap<String, Collection<String>>();
            LDAPEntry entry = this._ldapConnection.read(principal);
            LDAPAttributeSet attributeSet = entry.getAttributeSet();
            if (attributeSet != null) {
                for (LDAPAttribute attribute : attributeSet) {
                    if (attribute == null) continue;
                    ArrayList<String> values = new ArrayList<String>();
                    String name = attribute.getName();
                    Enumeration valueEnum = attribute.getStringValues();
                    while (valueEnum.hasMoreElements()) {
                        String value = (String)valueEnum.nextElement();
                        values.add(value);
                    }
                    properties.put(name, values);
                }
            }
            return properties;
        }
        catch (Exception e) {
            String msg = "error getting properties of principal " + principal;
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public Set<String> resolveGroupMembers(String group) throws SecurityException {
        if (group == null) {
            throw new SecurityException("parameter group is null");
        }
        this.ensureConnection();
        try {
            HashSet<String> members = new HashSet<String>();
            LDAPEntry entry = this._ldapConnection.read(group);
            LDAPAttributeSet attributeSet = entry.getAttributeSet();
            if (attributeSet != null) {
                if (this.containsGroupAttribute(attributeSet)) {
                    LDAPAttribute attribute = attributeSet.getAttribute(LDAP_ATTRIBUTE_MEMBER);
                    this.appendGroupMembers(members, attribute);
                    attribute = attributeSet.getAttribute(LDAP_ATTRIBUTE_UNIQUE_MEMBER);
                    this.appendGroupMembers(members, attribute);
                } else {
                    throw new SecurityException("group " + group + " is not a group");
                }
            }
            return members;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "error resolving members for group " + group;
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public Set<String> resolveMembership(String principal) throws SecurityException {
        if (principal == null) {
            throw new SecurityException("parameter principal is null");
        }
        this.ensureConnection();
        try {
            LDAPAttribute attribute;
            HashSet<String> groups = new HashSet<String>();
            LDAPEntry entry = this._ldapConnection.read(principal);
            LDAPAttributeSet attributeSet = entry.getAttributeSet();
            if (attributeSet != null && (attribute = attributeSet.getAttribute(LDAP_ATTRIBUTE_MEMBER_OF)) != null) {
                Enumeration values = attribute.getStringValues();
                while (values.hasMoreElements()) {
                    String group = (String)values.nextElement();
                    groups.add(group);
                }
            }
            return groups;
        }
        catch (Exception e) {
            String msg = "error resolving membership of principal " + principal;
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public boolean isGroup(String principal) throws SecurityException {
        if (principal == null) {
            throw new SecurityException("parameter principal is null");
        }
        this.ensureConnection();
        try {
            LDAPEntry entry = this._ldapConnection.read(principal);
            LDAPAttributeSet attributeSet = entry.getAttributeSet();
            return this.containsGroupAttribute(attributeSet);
        }
        catch (Exception e) {
            String msg = "error checking if principal " + principal + " is a group";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    private boolean containsGroupAttribute(LDAPAttributeSet attributeSet) {
        LDAPAttribute attribute;
        if (attributeSet != null && (attribute = attributeSet.getAttribute(LDAP_ATTRIBUTE_OBJECT_CLASS)) != null) {
            Enumeration objectClassEnum = attribute.getStringValues();
            while (objectClassEnum.hasMoreElements()) {
                String objectName = (String)objectClassEnum.nextElement();
                if (!LDAP_OBJECT_NAME_GROUP.equalsIgnoreCase(objectName) && !LDAP_OBJECT_NAME_GROUP_OF_NAMES.equalsIgnoreCase(objectName) && !LDAP_OBJECT_NAME_GROUP_OF_UNIQUE_NAMES.equalsIgnoreCase(objectName) && !LDAP_OBJECT_NAME_DYNAMIC_GROUP.equalsIgnoreCase(objectName) && !LDAP_OBJECT_NAME_DYNAMIC_GROUP_AUX.equalsIgnoreCase(objectName)) continue;
                return true;
            }
        }
        return false;
    }

    private void appendGroupMembers(HashSet<String> members, LDAPAttribute attribute) {
        if (attribute != null) {
            Enumeration values = attribute.getStringValues();
            while (values.hasMoreElements()) {
                String member = (String)values.nextElement();
                members.add(member);
            }
        }
    }

    private void readConfiguration() throws IOException {
        this._properties = new Properties();
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_NAME, (String)CONFIGURATION_FILE);
                this._properties.load(configurationFileStream);
            }
            catch (IOException ex) {
                throw new IOException("Could not read configuration property file ldap.properties: " + ex.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }

    private void ensureConnection() throws SecurityException {
        try {
            if (this._ldapConnection == null || !this._ldapConnection.isConnected() || !this._ldapConnection.isConnectionAlive()) {
                this._ldapConnection = new LDAPConnection();
                this._ldapConnection.connect(this._properties.getProperty(PROPERTY_LDAP_HOST), Integer.parseInt(this._properties.getProperty(PROPERTY_LDAP_PORT, Integer.toString(389))));
                this._ldapConnection.bind(3, this._properties.getProperty(PROPERTY_LDAP_LOGIN), this._properties.getProperty(PROPERTY_LDAP_PASSWORD).getBytes("UTF8"));
            }
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Error ensuring LDAP connection", (Throwable)e);
            }
            throw new SecurityException("Error ensuring LDAP connection", (Throwable)e);
        }
    }
}

