/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.feed;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.importing.crawler.feed.FeedProperties;

public class RomeFeedReader {
    private final Log _log = LogFactory.getLog(this.getClass());

    public Collection<Record> readFeed(String feedUrl) throws Exception {
        ArrayList<Record> results = new ArrayList<Record>();
        FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
        HttpURLFeedFetcher feedFetcher = new HttpURLFeedFetcher(feedInfoCache);
        SyndFeed feed = feedFetcher.retrieveFeed(new URL(feedUrl));
        if (feed != null) {
            List entries;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Reading feed " + feedUrl));
            }
            if ((entries = feed.getEntries()) != null) {
                for (SyndEntry entry : entries) {
                    Record r = DataFactory.DEFAULT.createRecord();
                    for (String feedProp : FeedProperties.ALL_PROPS) {
                        Any value = this.readProperty(feed, entry, feedProp);
                        if (value == null) continue;
                        r.getMetadata().put(feedProp, value);
                    }
                    results.add(r);
                }
            }
        }
        return results;
    }

    private Any readProperty(SyndFeed feed, SyndEntry entry, String property) {
        switch (property) {
            case "feedAuthors": {
                return this.getPersons(feed.getAuthors(), feed.getAuthor());
            }
            case "feedCategories": {
                return this.getCategories(feed.getCategories());
            }
            case "feedContributors": {
                return this.getPersons(feed.getContributors(), null);
            }
            case "feedCopyright": {
                return this.getValue(feed.getCopyright());
            }
            case "feedDescription": {
                return this.getValue(feed.getDescription());
            }
            case "feedEncoding": {
                return this.getValue(feed.getEncoding());
            }
            case "feedType": {
                return this.getValue(feed.getFeedType());
            }
            case "feedImage": {
                return this.getImage(feed.getImage());
            }
            case "feedLanguage": {
                return this.getValue(feed.getLanguage());
            }
            case "feedLinks": {
                return this.getLinks(feed.getLinks(), feed.getLink());
            }
            case "feedPublishDate": {
                return this.getValue(feed.getPublishedDate());
            }
            case "feedTitle": {
                return this.getValue(feed.getTitle());
            }
            case "feedUri": {
                return this.getValue(feed.getUri());
            }
            case "itemAuthors": {
                return this.getPersons(entry.getAuthors(), entry.getAuthor());
            }
            case "itemCategories": {
                return this.getCategories(entry.getCategories());
            }
            case "itemContents": {
                return this.getContents(entry.getContents());
            }
            case "itemContributors": {
                return this.getPersons(entry.getContributors(), null);
            }
            case "itemDescription": {
                return this.getContent(entry.getDescription());
            }
            case "itemEnclosures": {
                return this.getEnclosures(entry.getEnclosures());
            }
            case "itemLinks": {
                return this.getLinks(entry.getLinks(), entry.getLink());
            }
            case "itemPublishDate": {
                return this.getValue(entry.getPublishedDate());
            }
            case "itemTitle": {
                return this.getValue(entry.getTitle());
            }
            case "itemUri": {
                return this.getValue(entry.getUri());
            }
            case "itemUpdateDate": {
                return this.getValue(entry.getUpdatedDate());
            }
        }
        throw new RuntimeException("Unknown feed property: " + property);
    }

    private Value getValue(Object object) {
        if (object != null) {
            return DataFactory.DEFAULT.autoConvertValue(object);
        }
        return null;
    }

    private void putValue(AnyMap map, String name, Object object) {
        Value value = this.getValue(object);
        if (value != null) {
            map.put(name, (Any)value);
        }
    }

    private AnySeq getCategories(List<SyndCategory> categories) {
        if (categories != null && !categories.isEmpty()) {
            AnySeq categoryList = DataFactory.DEFAULT.createAnySeq();
            for (SyndCategory category : categories) {
                try {
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(anyMap, "Name", category.getName());
                    this.putValue(anyMap, "TaxanomyUri", category.getTaxonomyUri());
                    categoryList.add((Object)anyMap);
                }
                catch (InvalidValueTypeException e) {
                    this._log.error((Object)"Error while creating AnyMap for Categories", (Throwable)e);
                }
            }
            return categoryList;
        }
        return null;
    }

    private AnyMap getContent(SyndContent content) {
        if (content != null) {
            try {
                String type;
                AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                if (content.getMode() != null) {
                    this.putValue(anyMap, "Mode", content.getMode());
                }
                if (content.getValue() != null) {
                    this.putValue(anyMap, "Value", content.getValue());
                }
                if ("html".equals(type = content.getType())) {
                    type = "text/html";
                } else if ("xml".equals(type)) {
                    type = "text/xml";
                } else if ("text".equals(type)) {
                    type = "text/Plain";
                }
                this.putValue(anyMap, "Type", type);
                return anyMap;
            }
            catch (InvalidValueTypeException e) {
                this._log.error((Object)"Error while creating AnyMap for Content", (Throwable)e);
            }
        }
        return null;
    }

    private AnySeq getContents(List<SyndContent> contents) {
        if (contents != null && !contents.isEmpty()) {
            AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
            for (SyndContent content : contents) {
                AnyMap anyMap = this.getContent(content);
                if (anyMap == null) continue;
                anySeq.add((Object)anyMap);
            }
            return anySeq;
        }
        return null;
    }

    private AnySeq getEnclosures(List<SyndEnclosure> enclosures) {
        if (enclosures != null && !enclosures.isEmpty()) {
            AnySeq enclosureList = DataFactory.DEFAULT.createAnySeq();
            for (SyndEnclosure enclosure : enclosures) {
                try {
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(anyMap, "Type", enclosure.getType());
                    this.putValue(anyMap, "Url", enclosure.getUrl());
                    this.putValue(anyMap, "Length", enclosure.getLength());
                    enclosureList.add((Object)anyMap);
                }
                catch (InvalidValueTypeException e) {
                    this._log.error((Object)"Error while creating AnyMap for Enclosures", (Throwable)e);
                }
            }
            return enclosureList;
        }
        return null;
    }

    private AnyMap getImage(SyndImage feedImage) {
        if (feedImage != null) {
            try {
                AnyMap imageMap = DataFactory.DEFAULT.createAnyMap();
                this.putValue(imageMap, "Link", feedImage.getLink());
                this.putValue(imageMap, "Title", feedImage.getTitle());
                this.putValue(imageMap, "Url", feedImage.getUrl());
                this.putValue(imageMap, "Description", feedImage.getDescription());
                return imageMap;
            }
            catch (InvalidValueTypeException e) {
                this._log.error((Object)"Error while creating AnyMap for Image", (Throwable)e);
            }
        }
        return null;
    }

    private AnySeq getLinks(List<SyndLink> links, String fallbackValue) {
        AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
        if (links != null && !links.isEmpty()) {
            for (SyndLink link : links) {
                try {
                    AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(anyMap, "Href", link.getHref());
                    this.putValue(anyMap, "Hreflang", link.getHreflang());
                    this.putValue(anyMap, "Rel", link.getRel());
                    this.putValue(anyMap, "Title", link.getTitle());
                    this.putValue(anyMap, "Type", link.getType());
                    this.putValue(anyMap, "Length", link.getLength());
                    anySeq.add((Object)anyMap);
                }
                catch (InvalidValueTypeException e) {
                    this._log.error((Object)"Error while creating AnyMap for Links", (Throwable)e);
                }
            }
            return anySeq;
        }
        if (fallbackValue != null && !fallbackValue.isEmpty()) {
            try {
                AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
                this.putValue(anyMap, "Href", fallbackValue);
                anySeq.add((Object)anyMap);
                return anySeq;
            }
            catch (InvalidValueTypeException e) {
                this._log.error((Object)"Error while creating AnyMap for Links", (Throwable)e);
            }
        }
        return null;
    }

    private AnySeq getPersons(List<SyndPerson> persons, String fallbackValue) {
        AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
        if (persons != null && !persons.isEmpty()) {
            for (SyndPerson person : persons) {
                try {
                    AnyMap personMap = DataFactory.DEFAULT.createAnyMap();
                    this.putValue(personMap, "Email", person.getEmail());
                    this.putValue(personMap, "Name", person.getName());
                    this.putValue(personMap, "Uri", person.getUri());
                    anySeq.add((Object)personMap);
                }
                catch (InvalidValueTypeException e) {
                    this._log.error((Object)"Error while creating AnyMap for Person", (Throwable)e);
                }
            }
            return anySeq;
        }
        if (fallbackValue != null && !fallbackValue.isEmpty()) {
            try {
                AnyMap personMap = DataFactory.DEFAULT.createAnyMap();
                this.putValue(personMap, "Name", fallbackValue);
                anySeq.add((Object)personMap);
                return anySeq;
            }
            catch (InvalidValueTypeException e) {
                this._log.error((Object)"Error while creating AnyMap for Person", (Throwable)e);
            }
        }
        return null;
    }
}

