/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.attachments;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.eclipse.smila.http.client.Attachments;

public class AttachmentWrapper
implements Attachments {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final Map<String, ContentBody> _parts = new LinkedHashMap<String, ContentBody>();

    public AttachmentWrapper() {
    }

    public AttachmentWrapper(String name, byte[] attachment) {
        this.add(name, attachment);
    }

    public AttachmentWrapper(String name, String attachment) {
        this.add(name, attachment);
    }

    public AttachmentWrapper(String name, InputStream attachment) {
        this.add(name, attachment);
    }

    public AttachmentWrapper(String name, File attachment) {
        this.add(name, attachment);
    }

    @Override
    public Map<String, ContentBody> getAttachmentParts() {
        return this._parts;
    }

    public void add(String name, byte[] attachment) {
        this._parts.put(name, (ContentBody)new ByteArrayBody(attachment, "application/octet-stream", null));
    }

    public void add(String name, String attachment) {
        try {
            this._parts.put(name, (ContentBody)new StringBody(attachment, "application/octet-stream", CHARSET));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Charset '" + CHARSET + "' unknown. Operation impossible.");
        }
    }

    public void add(String name, InputStream attachment) {
        this._parts.put(name, (ContentBody)new InputStreamBody(attachment, "application/octet-stream", null));
    }

    public void add(String name, File attachment) {
        this._parts.put(name, (ContentBody)new FileBody(attachment, "application/octet-stream"));
    }
}

