/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.exceptions;

import java.io.IOException;

import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.utils.MaybeRecoverableException;

/**
 * Base class for exception thrown by JobManager methods. There may be subclasses to distinguish between different error
 * types. Contains a flag to describe if it makes sense for the client to retry the operation.
 */
public class JobManagerException extends MaybeRecoverableException {

  /** is serializable. */
  private static final long serialVersionUID = 2L;

  /**
   * create exception with description and cause.
   */
  public JobManagerException(final String message, final Throwable cause) {
    this(message, cause, isRecoverableCause(cause));
  }

  /**
   * create exception with description.
   */
  public JobManagerException(final String message) {
    this(message, false);
  }

  /**
   * create exception with description and cause.
   */
  public JobManagerException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

  /**
   * create exception with description.
   */
  public JobManagerException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }


  /** auto-detection of causes that should be recoverable. */
  public static boolean isRecoverableCause(final Throwable cause) {
    if (MaybeRecoverableException.isRecoverableCause(cause)) {
      return true;
    }
    // standard meaning of ObjectStoreService exceptions.
    if (cause instanceof IOException || cause instanceof ServiceUnavailableException) {
      return true;
    }
    return false;
  }

}
